package sila_java.interoperability.client.features;

import io.grpc.ManagedChannel;
import lombok.extern.slf4j.Slf4j;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.test.multiclienttest.v1.MultiClientTestGrpc;
import sila2.org.silastandard.test.multiclienttest.v1.MultiClientTestOuterClass;
import sila_java.library.core.sila.types.SiLAReal;



@Slf4j
public class MultiClientTest {
    private MultiClientTestGrpc.MultiClientTestBlockingStub blockingStub;

    public MultiClientTest(final ManagedChannel channel) {
        this.blockingStub = MultiClientTestGrpc.newBlockingStub(channel);
    }

    public void runInParallel() {
        log.info("lul");
        SiLAFramework.CommandConfirmation commandConfirmation = this.blockingStub.runInParallel(
                MultiClientTestOuterClass.RunInParallel_Parameters
                        .newBuilder()
                        .setDuration(SiLAReal.from(0.8))
                        .build()
        );
        try {
            //Thread.sleep(1000);
            MultiClientTestOuterClass.RunInParallel_Responses runInParallelResponses = this.blockingStub.runInParallelResult(
                    SiLAFramework.CommandExecutionUUID
                            .newBuilder()
                            .setValue(commandConfirmation.getCommandExecutionUUID().getValue())
                            .build()
            );
        } catch (Exception e) {
            log.info("", e);
        }
        /*Iterator<SiLAFramework.ExecutionInfo> executionInfoIterator = this.blockingStub.runInParallelInfo(
                SiLAFramework.CommandExecutionUUID
                        .newBuilder()
                        .setValue(commandConfirmation.getCommandExecutionUUID().getValue())
                        .build()
        );*/
    }

}
