/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client;

import io.grpc.ManagedChannel;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.interoperability.client.features.Authentication;
import sila_java.interoperability.client.features.AuthenticationTest;
import sila_java.interoperability.client.features.AuthorizationTest;
import sila_java.interoperability.client.features.BinaryTransferTest;
import sila_java.interoperability.client.features.ErrorHandlingTest;
import sila_java.interoperability.client.features.MetadataConsumerTest;
import sila_java.interoperability.client.features.MetadataProvider;
import sila_java.interoperability.client.features.ObservableCommandTest;
import sila_java.interoperability.client.features.ObservablePropertyTest;
import sila_java.interoperability.client.features.SiLAServiceTest;
import sila_java.interoperability.client.features.UnobservableCommandTest;
import sila_java.interoperability.client.features.UnobservablePropertyTest;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.models.Server;
import sila_java.library.manager.server_management.Connection;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    public static final String SERVER_TYPE = "TestServer";
    private final UnobservablePropertyTest unobservablePropertyTest;
    private final UnobservableCommandTest unobservableCommandTest;
    private final ObservablePropertyTest observablePropertyTest;
    private final ObservableCommandTest observableCommandTest;
    private final MetadataProvider metadataProvider;
    private final MetadataConsumerTest metadataConsumerTest;
    private final ErrorHandlingTest errorHandlingTest;
    private final BinaryTransferTest binaryTransferTest;
    private final SiLAServiceTest silaServiceTest;
    private final Authentication authentication;
    private final AuthenticationTest authenticationTest;
    private final AuthorizationTest authorizationTest;

    public Client(@NonNull UUID serverUUID) {
        if (serverUUID == null) {
            throw new NullPointerException("serverUUID is marked non-null but is null");
        }
        Connection connection = (Connection)ServerManager.getInstance().getConnections().get(serverUUID);
        ManagedChannel serviceChannel = connection.getManagedChannel();
        this.silaServiceTest = new SiLAServiceTest(serviceChannel);
        this.unobservablePropertyTest = new UnobservablePropertyTest(serviceChannel);
        this.unobservableCommandTest = new UnobservableCommandTest(serviceChannel);
        this.observablePropertyTest = new ObservablePropertyTest(serviceChannel);
        this.observableCommandTest = new ObservableCommandTest(serviceChannel);
        this.metadataProvider = new MetadataProvider(serviceChannel);
        this.metadataConsumerTest = new MetadataConsumerTest(serverUUID);
        this.errorHandlingTest = new ErrorHandlingTest(serviceChannel);
        this.binaryTransferTest = new BinaryTransferTest(serviceChannel, serverUUID);
        this.authentication = new Authentication(serviceChannel, serverUUID);
        this.authenticationTest = new AuthenticationTest(serviceChannel, serverUUID);
        this.authorizationTest = new AuthorizationTest(serviceChannel);
    }

    public static void main(String[] args) {
        try (ServerManager serverManager = ServerManager.getInstance();){
            serverManager.setAllowInsecureConnection(true);
            ServerManager.getInstance().addServer("127.0.0.1", 50053);
            Server server = ServerManager.getInstance().getServers().values().stream().filter(s -> s.getInformation().getType().equals(SERVER_TYPE)).findAny().orElseThrow(RuntimeException::new);
            log.info("Found Server!");
            Client client = new Client(server.getConfiguration().getUuid());
            client.runSiLAServiceTest();
            client.runUnobservablePropertyTest();
            client.runUnobservableCommandTest();
            client.runObservablePropertyTest();
            client.runObservableCommandTest();
            client.runMetadataProvider();
            client.runMetadataConsumerTest();
            client.runErrorHandlingTest();
            client.authorizationTest();
            client.authentication();
            client.authenticationTest();
            client.runBinaryTransferTest();
        }
    }

    public void runBinaryTransferTest() {
        this.binaryTransferTest.echoBinaryValue(StringUtils.repeat((String)"abc", (int)1).getBytes(StandardCharsets.UTF_8));
        this.binaryTransferTest.echoBinaryValue(StringUtils.repeat((String)"SiLA2_Test_String_Value", (int)1).getBytes(StandardCharsets.UTF_8));
        this.binaryTransferTest.echoBinaryValue(StringUtils.repeat((String)"abc", (int)1000000).getBytes(StandardCharsets.UTF_8));
        this.binaryTransferTest.echoBinariesObservably(StringUtils.repeat((String)"abc", (int)1).getBytes(StandardCharsets.UTF_8), StringUtils.repeat((String)"abc", (int)1000000).getBytes(StandardCharsets.UTF_8), StringUtils.repeat((String)"SiLA2_Test_String_Value", (int)1).getBytes(StandardCharsets.UTF_8));
        this.binaryTransferTest.echoBinaryAndMetadataString(StringUtils.repeat((String)"abc", (int)1).getBytes(StandardCharsets.UTF_8));
        this.binaryTransferTest.echoBinaryAndMetadataString(StringUtils.repeat((String)"abc", (int)1000000).getBytes(StandardCharsets.UTF_8));
        this.binaryTransferTest.binaryValueDownload();
        this.binaryTransferTest.binaryValueDirectly();
        this.binaryTransferTest.getFCPAffectedByMetadataString();
    }

    public void runErrorHandlingTest() {
        this.errorHandlingTest.raiseDefinedExecutionError();
        this.errorHandlingTest.raiseDefinedExecutionErrorObservably();
        this.errorHandlingTest.raiseUndefinedExecutionError();
        this.errorHandlingTest.raiseUndefinedExecutionErrorObservably();
        this.errorHandlingTest.raiseDefinedExecutionErrorOnGet();
        this.errorHandlingTest.raiseDefinedExecutionErrorOnSubscribe();
        this.errorHandlingTest.raiseUndefinedExecutionErrorOnGet();
        this.errorHandlingTest.raiseUndefinedExecutionErrorOnSubscribe();
        this.errorHandlingTest.raiseDefinedExecutionErrorAfterValueWasSent();
        this.errorHandlingTest.raiseUndefinedExecutionErrorAfterValueWasSent();
    }

    public void runMetadataConsumerTest() {
        this.metadataConsumerTest.echoStringMetadata();
        this.metadataConsumerTest.unpackMetadata();
        this.metadataConsumerTest.getReceivedStringMetadata();
        this.metadataConsumerTest.subscribeReceivedStringMetadataAsCharacters();
    }

    public void runMetadataProvider() {
        this.metadataProvider.getFCPAffectedByMetadataStringMetadata();
        this.metadataProvider.getFCPAffectedByMetadataTwoIntegersMetadata();
    }

    public void runObservableCommandTest() {
        this.observableCommandTest.count(1.0, 5);
        this.observableCommandTest.echo(5.0, 3L);
    }

    public void runObservablePropertyTest() {
        this.observablePropertyTest.subscribeFixedValue();
        this.observablePropertyTest.subscribeAlternating();
        this.observablePropertyTest.subscribeEditable();
        this.observablePropertyTest.setValue(1L);
        this.observablePropertyTest.setValue(2L);
        this.observablePropertyTest.setValue(3L);
    }

    public void runUnobservableCommandTest() {
        this.unobservableCommandTest.commandWithParametersAndResponses();
        this.unobservableCommandTest.convertIntegerToString(12345);
        this.unobservableCommandTest.joinIntegerAndString(123, "abc");
        this.unobservableCommandTest.splitStringAfterFirstChar("");
        this.unobservableCommandTest.splitStringAfterFirstChar("a");
        this.unobservableCommandTest.splitStringAfterFirstChar("ab");
        this.unobservableCommandTest.splitStringAfterFirstChar("abcde");
    }

    public void runUnobservablePropertyTest() {
        this.unobservablePropertyTest.answerToEverything();
        this.unobservablePropertyTest.secondsSince1970();
    }

    public void authentication() {
        String token = this.authentication.login("test", "test");
        this.authentication.logout(token);
    }

    public void authenticationTest() {
        String token = this.authentication.login("test", "test");
        this.authenticationTest.requiresToken(token);
        this.authenticationTest.requiresTokenForBinaryUpload(token, StringUtils.repeat((String)"abc", (int)1).getBytes(StandardCharsets.UTF_8));
        this.authenticationTest.requiresTokenForBinaryUpload(token, StringUtils.repeat((String)"abc", (int)1000000).getBytes(StandardCharsets.UTF_8));
        this.authentication.logout(token);
    }

    public void authorizationTest() {
        this.authorizationTest.getFCPAffectedByMetadataAccessToken();
    }

    public void runSiLAServiceTest() {
        this.silaServiceTest.setServerName("SiLA is Awesome");
    }
}

