/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import com.google.protobuf.MessageOrBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import sila2.org.silastandard.test.metadataprovider.v1.MetadataProviderOuterClass;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.core.sila.types.SiLAInteger;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.executor.ExecutableServerCall;
import sila_java.library.manager.models.SiLACall;

public class MetadataConsumerTest {
    private final UUID serverUUID;

    public MetadataConsumerTest(@NonNull UUID serverUUID) {
        if (serverUUID == null) {
            throw new NullPointerException("serverUUID is marked non-null but is null");
        }
        this.serverUUID = serverUUID;
    }

    public void echoStringMetadata() {
        String metadatum = "{\"org.silastandard/test/MetadataProvider/v1/Metadata/StringMetadata\":" + ProtoMapper.serializeToJson((MessageOrBuilder)MetadataProviderOuterClass.Metadata_StringMetadata.newBuilder().setStringMetadata(SiLAString.from((String)"abc")).build()) + "}";
        SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/MetadataConsumerTest/v1", "EchoStringMetadata", SiLACall.Type.UNOBSERVABLE_COMMAND).withMetadata(metadatum).build();
        String string = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).build()).get(20L, TimeUnit.SECONDS);
    }

    public void getReceivedStringMetadata() {
        String metadatum = "{\"org.silastandard/test/MetadataProvider/v1/Metadata/StringMetadata\":" + ProtoMapper.serializeToJson((MessageOrBuilder)MetadataProviderOuterClass.Metadata_StringMetadata.newBuilder().setStringMetadata(SiLAString.from((String)"abc")).build()) + "}";
        SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/MetadataConsumerTest/v1", "ReceivedStringMetadata", SiLACall.Type.UNOBSERVABLE_PROPERTY).withMetadata(metadatum).build();
        String string = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).build()).get(20L, TimeUnit.SECONDS);
    }

    public void subscribeReceivedStringMetadataAsCharacters() {
        String metadatum = "{\"org.silastandard/test/MetadataProvider/v1/Metadata/StringMetadata\":" + ProtoMapper.serializeToJson((MessageOrBuilder)MetadataProviderOuterClass.Metadata_StringMetadata.newBuilder().setStringMetadata(SiLAString.from((String)"abc")).build()) + "}";
        SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/MetadataConsumerTest/v1", "ReceivedStringMetadataAsCharacters", SiLACall.Type.OBSERVABLE_PROPERTY).withMetadata(metadatum).build();
        String string = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).build()).get(20L, TimeUnit.SECONDS);
    }

    public void unpackMetadata() {
        String metadatum = "{\"org.silastandard/test/MetadataProvider/v1/Metadata/TwoIntegersMetadata\":" + ProtoMapper.serializeToJson((MessageOrBuilder)MetadataProviderOuterClass.Metadata_TwoIntegersMetadata.newBuilder().setTwoIntegersMetadata(MetadataProviderOuterClass.Metadata_TwoIntegersMetadata.TwoIntegersMetadata_Struct.newBuilder().setFirstInteger(SiLAInteger.from((long)123L)).setSecondInteger(SiLAInteger.from((long)456L)).build()).build()) + ",\n \"org.silastandard/test/MetadataProvider/v1/Metadata/StringMetadata\":" + ProtoMapper.serializeToJson((MessageOrBuilder)MetadataProviderOuterClass.Metadata_StringMetadata.newBuilder().setStringMetadata(SiLAString.from((String)"abc")).build()) + "}";
        SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/MetadataConsumerTest/v1", "UnpackMetadata", SiLACall.Type.UNOBSERVABLE_COMMAND).withMetadata(metadatum).build();
        String string = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).build()).get(20L, TimeUnit.SECONDS);
    }
}

