/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.core.sila.types.SiLAString;

public class SiLAServiceTest {
    private static final Logger log = LoggerFactory.getLogger(SiLAServiceTest.class);
    private final SiLAServiceGrpc.SiLAServiceBlockingStub blockingStub;

    public SiLAServiceTest(@NonNull ManagedChannel serviceChannel) {
        if (serviceChannel == null) {
            throw new NullPointerException("serviceChannel is marked non-null but is null");
        }
        this.blockingStub = SiLAServiceGrpc.newBlockingStub((Channel)serviceChannel);
    }

    public void setServerName(@NonNull String newServerName) {
        if (newServerName == null) {
            throw new NullPointerException("newServerName is marked non-null but is null");
        }
        log.info("Setting server name to {}", (Object)newServerName);
        this.blockingStub.setServerName(SiLAServiceOuterClass.SetServerName_Parameters.newBuilder().setServerName(SiLAString.from((String)newServerName)).build());
    }
}

