"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
from . import SiLAService_pb2
import abc
import grpc

class SiLAServiceStub:
    """This Feature MUST be implemented by each SiLA Server. It specifies Commands and Properties to discover the Features a SiLA Server implements as well as details about the SiLA Server, like name, type, description, vendor and UUID. Any interaction described in this feature MUST not affect the behaviour of any other Feature."""

    def __init__(self, channel: grpc.Channel) -> None: ...
    GetFeatureDefinition: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.GetFeatureDefinition_Parameters, SiLAService_pb2.GetFeatureDefinition_Responses
    ]
    """Get the Feature Definition of an implemented Feature by its fully qualified Feature Identifier. This command has no preconditions and no further dependencies and can be called at any time."""

    SetServerName: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.SetServerName_Parameters, SiLAService_pb2.SetServerName_Responses
    ]
    """Sets a human readable name to the Server Name Property.Command has no preconditions and no further dependencies and can be called at any time."""

    Get_ServerName: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.Get_ServerName_Parameters, SiLAService_pb2.Get_ServerName_Responses
    ]
    """
    Human readable name of the SiLA Server. The name can be set using the 'Set Server Name' command.
    """

    Get_ServerType: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.Get_ServerType_Parameters, SiLAService_pb2.Get_ServerType_Responses
    ]
    """
    The type of this server. It, could be, e.g., in the case of a SiLA Device the model name.
    It is specified by the implementer of the SiLA Server and MAY not be unique.
    """

    Get_ServerUUID: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.Get_ServerUUID_Parameters, SiLAService_pb2.Get_ServerUUID_Responses
    ]
    """
    Globally unique identifier that identifies a SiLA Server. The Server UUID MUST be generated once
    and remain the same for all times.
    """

    Get_ServerDescription: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.Get_ServerDescription_Parameters, SiLAService_pb2.Get_ServerDescription_Responses
    ]
    """
    Description of the SiLA Server. This should include the use and purpose of this SiLA Server.
    """

    Get_ServerVersion: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.Get_ServerVersion_Parameters, SiLAService_pb2.Get_ServerVersion_Responses
    ]
    """
    Returns the version of the SiLA Server. A "Major" and a "Minor" version number (e.g. 1.0) MUST be provided,
    a Patch version number MAY be provided. Optionally, an arbitrary text, separated by an underscore MAY be
    appended, e.g. “3.19.373_mighty_lab_devices”.
    """

    Get_ServerVendorURL: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.Get_ServerVendorURL_Parameters, SiLAService_pb2.Get_ServerVendorURL_Responses
    ]
    """
    Returns the URL to the website of the vendor or the website of the product of this SiLA Server.
    This URL SHOULD be accessible at all times.
    The URL is a Uniform Resource Locator as defined in RFC 1738.
    """

    Get_ImplementedFeatures: grpc.UnaryUnaryMultiCallable[
        SiLAService_pb2.Get_ImplementedFeatures_Parameters, SiLAService_pb2.Get_ImplementedFeatures_Responses
    ]
    """
    Returns a list of fully qualified Feature identifiers of all implemented Features of this SiLA Server.
    This list SHOULD remain the same throughout the lifetime of the SiLA Server.
    """

class SiLAServiceServicer(metaclass=abc.ABCMeta):
    """This Feature MUST be implemented by each SiLA Server. It specifies Commands and Properties to discover the Features a SiLA Server implements as well as details about the SiLA Server, like name, type, description, vendor and UUID. Any interaction described in this feature MUST not affect the behaviour of any other Feature."""

    @abc.abstractmethod
    def GetFeatureDefinition(
        self,
        request: SiLAService_pb2.GetFeatureDefinition_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.GetFeatureDefinition_Responses:
        """Get the Feature Definition of an implemented Feature by its fully qualified Feature Identifier. This command has no preconditions and no further dependencies and can be called at any time."""
        pass
    @abc.abstractmethod
    def SetServerName(
        self,
        request: SiLAService_pb2.SetServerName_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.SetServerName_Responses:
        """Sets a human readable name to the Server Name Property.Command has no preconditions and no further dependencies and can be called at any time."""
        pass
    @abc.abstractmethod
    def Get_ServerName(
        self,
        request: SiLAService_pb2.Get_ServerName_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.Get_ServerName_Responses:
        """
        Human readable name of the SiLA Server. The name can be set using the 'Set Server Name' command.
        """
        pass
    @abc.abstractmethod
    def Get_ServerType(
        self,
        request: SiLAService_pb2.Get_ServerType_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.Get_ServerType_Responses:
        """
        The type of this server. It, could be, e.g., in the case of a SiLA Device the model name.
        It is specified by the implementer of the SiLA Server and MAY not be unique.
        """
        pass
    @abc.abstractmethod
    def Get_ServerUUID(
        self,
        request: SiLAService_pb2.Get_ServerUUID_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.Get_ServerUUID_Responses:
        """
        Globally unique identifier that identifies a SiLA Server. The Server UUID MUST be generated once
        and remain the same for all times.
        """
        pass
    @abc.abstractmethod
    def Get_ServerDescription(
        self,
        request: SiLAService_pb2.Get_ServerDescription_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.Get_ServerDescription_Responses:
        """
        Description of the SiLA Server. This should include the use and purpose of this SiLA Server.
        """
        pass
    @abc.abstractmethod
    def Get_ServerVersion(
        self,
        request: SiLAService_pb2.Get_ServerVersion_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.Get_ServerVersion_Responses:
        """
        Returns the version of the SiLA Server. A "Major" and a "Minor" version number (e.g. 1.0) MUST be provided,
        a Patch version number MAY be provided. Optionally, an arbitrary text, separated by an underscore MAY be
        appended, e.g. “3.19.373_mighty_lab_devices”.
        """
        pass
    @abc.abstractmethod
    def Get_ServerVendorURL(
        self,
        request: SiLAService_pb2.Get_ServerVendorURL_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.Get_ServerVendorURL_Responses:
        """
        Returns the URL to the website of the vendor or the website of the product of this SiLA Server.
        This URL SHOULD be accessible at all times.
        The URL is a Uniform Resource Locator as defined in RFC 1738.
        """
        pass
    @abc.abstractmethod
    def Get_ImplementedFeatures(
        self,
        request: SiLAService_pb2.Get_ImplementedFeatures_Parameters,
        context: grpc.ServicerContext,
    ) -> SiLAService_pb2.Get_ImplementedFeatures_Responses:
        """
        Returns a list of fully qualified Feature identifiers of all implemented Features of this SiLA Server.
        This list SHOULD remain the same throughout the lifetime of the SiLA Server.
        """
        pass

def add_SiLAServiceServicer_to_server(servicer: SiLAServiceServicer, server: grpc.Server) -> None: ...
