/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.server;

import io.grpc.BindableService;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.interoperability.repository.EmptyClass;
import sila_java.interoperability.server.features.BinaryTransferTest;
import sila_java.interoperability.server.features.ErrorHandlingTest;
import sila_java.interoperability.server.features.MetadataConsumerTest;
import sila_java.interoperability.server.features.MetadataProvider;
import sila_java.interoperability.server.features.ObservableCommandTest;
import sila_java.interoperability.server.features.ObservablePropertyTest;
import sila_java.interoperability.server.features.UnobservableCommandTest;
import sila_java.interoperability.server.features.UnobservablePropertyTest;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.impl.H2BinaryDatabase;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;

public class Server
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    public static final String SERVER_TYPE = "InteroperabilitySiLAServer";
    private final BinaryDatabase binaryDatabase;
    private final SiLAServer server;
    public static final ServerInformation serverInfo = new ServerInformation("InteroperabilitySiLAServer", "Interoperability SiLA Server", "https://www.sila-standard.org", "0.1");
    private final IServerConfigWrapper configuration;

    Server(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            SiLAServer.Builder builder = SiLAServer.Builder.newBuilder((ServerInformation)serverInfo);
            builder.withPersistentConfig(argumentHelper.getConfigFile().isPresent());
            argumentHelper.getConfigFile().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPersistentConfigFile(arg_0));
            this.configuration = builder.getNewServerConfigurationWrapper();
            builder.withCustomConfigWrapperProvider((configPath, serverConfiguration) -> this.configuration);
            this.binaryDatabase = new H2BinaryDatabase(this.configuration.getCacheConfig().getUuid());
            builder.withCustomBinaryDatabaseProvider(uuid -> this.binaryDatabase);
            builder.withMetadataExtractingInterceptor();
            builder.withBinaryTransferSupport();
            builder.withUnsafeCommunication(true);
            builder.withPersistentTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            if (argumentHelper.useUnsafeCommunication()) {
                builder.withUnsafeCommunication(true);
            }
            argumentHelper.getHost().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withHost(arg_0));
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withNetworkInterface(arg_0));
            builder.withDiscovery(argumentHelper.hasNetworkDiscovery());
            String featuresPath = "/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/";
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/UnobservablePropertyTest.sila.xml"))), (BindableService)new UnobservablePropertyTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/UnobservableCommandTest.sila.xml"))), (BindableService)new UnobservableCommandTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/ObservablePropertyTest.sila.xml"))), (BindableService)new ObservablePropertyTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/ObservableCommandTest.sila.xml"))), (BindableService)new ObservableCommandTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/MetadataProvider.sila.xml"))), (BindableService)new MetadataProvider());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/MetadataConsumerTest.sila.xml"))), (BindableService)new MetadataConsumerTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/ErrorHandlingTest.sila.xml"))), (BindableService)new ErrorHandlingTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_interoperability/communication-tests/sila2_interop_communication_tester/resources/fdl/BinaryTransferTest.sila.xml"))), (BindableService)new BinaryTransferTest(this.binaryDatabase));
            builder.addFCPAffectedByMetadata("org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString", new String[]{"org.silastandard/test/BinaryTransferTest/v1/Metadata/String"});
            this.server = builder.start();
        }
        catch (IOException | SQLException e) {
            log.error("Something went wrong when building / starting server", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.server.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        Server server = new Server(argumentHelper);
        log.info("To stop the server press CTRL + C.");
        server.server.blockUntilShutdown();
        log.info("termination complete.");
    }
}

