/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.server;

import io.grpc.BindableService;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.authorizationservice.v1.AuthorizationServiceOuterClass;
import sila_java.interoperability.server.AuthTokens;
import sila_java.interoperability.server.features.AuthenticationService;
import sila_java.interoperability.server.features.AuthenticationTest;
import sila_java.interoperability.server.features.AuthorizationService;
import sila_java.interoperability.server.features.BinaryTransferTest;
import sila_java.interoperability.server.features.ErrorHandlingTest;
import sila_java.interoperability.server.features.MetadataConsumerTest;
import sila_java.interoperability.server.features.MetadataProvider;
import sila_java.interoperability.server.features.MultiClientTest;
import sila_java.interoperability.server.features.ObservableCommandTest;
import sila_java.interoperability.server.features.ObservablePropertyTest;
import sila_java.interoperability.server.features.UnobservableCommandTest;
import sila_java.interoperability.server.features.UnobservablePropertyTest;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.impl.H2BinaryDatabase;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.metadata.MetadataExtractingInterceptor;
import sila_java.library.server_base.metadata.ServerMetadataContainer;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.library.sila_base.EmptyClass;

public class Server
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    public static final String SERVER_TYPE = "InteroperabilitySiLAServer";
    private final BinaryDatabase binaryDatabase;
    private final SiLAServer server;
    public static final ServerInformation serverInfo = new ServerInformation("InteroperabilitySiLAServer", "Interoperability SiLA Server", "https://www.sila-standard.org", "0.1");
    private final IServerConfigWrapper configuration;
    private final AuthTokens authTokens;

    Server(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            SiLAServer.Builder builder = SiLAServer.Builder.newBuilder((ServerInformation)serverInfo);
            builder.withPersistentConfig(argumentHelper.getConfigFile().isPresent());
            argumentHelper.getConfigFile().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPersistentConfigFile(arg_0));
            this.configuration = builder.getNewServerConfigurationWrapper();
            builder.withCustomConfigWrapperProvider((configPath, serverConfiguration) -> this.configuration);
            UUID serverId = this.configuration.getCacheConfig().getUuid();
            this.authTokens = new AuthTokens(serverId);
            this.binaryDatabase = new H2BinaryDatabase(serverId);
            builder.withCustomBinaryDatabaseProvider(uuid -> this.binaryDatabase);
            builder.withMetadataExtractingInterceptor();
            builder.withBinaryTransferSupport();
            builder.withUnsafeCommunication(true);
            builder.withPersistentTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            if (argumentHelper.useUnsafeCommunication()) {
                builder.withUnsafeCommunication(true);
            }
            argumentHelper.getHost().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withHost(arg_0));
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withNetworkInterface(arg_0));
            builder.withDiscovery(argumentHelper.hasNetworkDiscovery());
            builder.withCustomAuthorizer(fqi -> {
                AuthorizationServiceOuterClass.Metadata_AccessToken accessToken;
                if (!fqi.startsWith("org.silastandard/test/AuthenticationTest/v1")) {
                    return;
                }
                ServerMetadataContainer serverMetadataContainer = (ServerMetadataContainer)MetadataExtractingInterceptor.SILA_METADATA_KEY.get();
                try {
                    accessToken = (AuthorizationServiceOuterClass.Metadata_AccessToken)serverMetadataContainer.get(AuthorizationServiceOuterClass.Metadata_AccessToken.class);
                }
                catch (Exception e) {
                    throw SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/AuthorizationService/v1/DefinedExecutionError/InvalidAccessToken", (String)"Invalid access token");
                }
                if (accessToken == null || !accessToken.hasAccessToken()) {
                    throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_METADATA, (String)"Missing metadata 'Access Token'.");
                }
                String token = accessToken.getAccessToken().getValue();
                if (!this.authTokens.getAuthTokens().containsKey(token) || this.authTokens.getAuthTokens().get(token).isBefore(Instant.now())) {
                    throw SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/AuthorizationService/v1/DefinedExecutionError/InvalidAccessToken", (String)"Invalid access token");
                }
            });
            String testFeaturesPath = "/sila_base/feature_definitions/org/silastandard/test/";
            String baseFeaturesPath = "/sila_base/feature_definitions/org/silastandard/core/";
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/UnobservablePropertyTest-v1_0.sila.xml"))), (BindableService)new UnobservablePropertyTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/UnobservableCommandTest-v1_0.sila.xml"))), (BindableService)new UnobservableCommandTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/ObservablePropertyTest-v1_0.sila.xml"))), (BindableService)new ObservablePropertyTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/ObservableCommandTest-v1_0.sila.xml"))), (BindableService)new ObservableCommandTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/MetadataProvider-v1_0.sila.xml"))), (BindableService)new MetadataProvider());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/MetadataConsumerTest-v1_0.sila.xml"))), (BindableService)new MetadataConsumerTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/ErrorHandlingTest-v1_0.sila.xml"))), (BindableService)new ErrorHandlingTest());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/BinaryTransferTest-v1_0.sila.xml"))), (BindableService)new BinaryTransferTest(this.binaryDatabase));
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/AuthenticationService-v1_0.sila.xml"))), (BindableService)new AuthenticationService(this.authTokens));
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/AuthenticationTest-v1_0.sila.xml"))), (BindableService)new AuthenticationTest(this.binaryDatabase, builder.getAuthorize()));
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/AuthorizationService-v1_0.sila.xml"))), (BindableService)new AuthorizationService());
            builder.addFeature(FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/MultiClientTest-v1_0.sila.xml"))), (BindableService)new MultiClientTest());
            builder.addFCPAffectedByMetadata("org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString", new String[]{"org.silastandard/test/BinaryTransferTest/v1/Metadata/String"});
            this.server = builder.start();
        }
        catch (IOException | SQLException e) {
            log.error("Something went wrong when building / starting server", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.server.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        Server server = new Server(argumentHelper);
        log.info("To stop the server press CTRL + C.");
        server.server.blockUntilShutdown();
        log.info("termination complete.");
    }
}

