/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.server.features;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.test.binarytransfertest.v1.BinaryTransferTestGrpc;
import sila2.org.silastandard.test.binarytransfertest.v1.BinaryTransferTestOuterClass;
import sila_java.library.core.sila.binary_transfer.BinaryInfo;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLABinary;
import sila_java.library.core.sila.types.SiLABinaryTransferUUID;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.server_base.binary_transfer.Binary;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;
import sila_java.library.server_base.command.observable.ObservableCommandManager;
import sila_java.library.server_base.command.observable.ObservableCommandTaskRunner;
import sila_java.library.server_base.command.observable.ObservableCommandWrapper;
import sila_java.library.server_base.command.observable.RunnableCommandTask;
import sila_java.library.server_base.metadata.MetadataExtractingInterceptor;
import sila_java.library.server_base.metadata.ServerMetadataContainer;

public class BinaryTransferTest
extends BinaryTransferTestGrpc.BinaryTransferTestImplBase {
    private static final int MAX_CHUNK_SIZE = 0x200000;
    private final BinaryDatabase binaryDatabase;
    private final ObservableCommandManager<BinaryTransferTestOuterClass.EchoBinariesObservably_Parameters, BinaryTransferTestOuterClass.EchoBinariesObservably_Responses> echoBinaryCommandManager;

    public BinaryTransferTest(final BinaryDatabase binaryDatabase) {
        this.binaryDatabase = binaryDatabase;
        this.echoBinaryCommandManager = new ObservableCommandManager(new ObservableCommandTaskRunner(1, 8), (RunnableCommandTask)new RunnableCommandTask<BinaryTransferTestOuterClass.EchoBinariesObservably_Parameters, BinaryTransferTestOuterClass.EchoBinariesObservably_Responses>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BinaryTransferTestOuterClass.EchoBinariesObservably_Responses run(ObservableCommandWrapper<BinaryTransferTestOuterClass.EchoBinariesObservably_Parameters, BinaryTransferTestOuterClass.EchoBinariesObservably_Responses> command) throws StatusRuntimeException {
                List<SiLAFramework.Binary> binaries = ((BinaryTransferTestOuterClass.EchoBinariesObservably_Parameters)command.getParameter()).getBinariesList();
                long totalSize = 0L;
                for (SiLAFramework.Binary binary : binaries) {
                    if (binary.hasValue()) {
                        totalSize += (long)binary.getValue().size();
                        continue;
                    }
                    try {
                        BinaryInfo info = binaryDatabase.getBinaryInfo(SiLABinaryTransferUUID.from((SiLAFramework.Binary)binary));
                        totalSize += info.getLength();
                    }
                    catch (BinaryDatabaseException e) {
                        throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.UNRECOGNIZED, (String)"");
                    }
                }
                ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(binaries.size());
                try {
                    BinaryTransferTestOuterClass.EchoBinariesObservably_Responses response;
                    for (SiLAFramework.Binary binary : binaries) {
                        if (binary.hasValue()) {
                            inputStreams.add(binary.getValue().newInput());
                            continue;
                        }
                        try {
                            Binary largeBinary = binaryDatabase.getBinary(SiLABinaryTransferUUID.from((SiLAFramework.Binary)binary));
                            inputStreams.add(largeBinary.getData().getBinaryStream());
                        }
                        catch (SQLException | BinaryDatabaseException e) {
                            throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.UNRECOGNIZED, (String)"");
                        }
                    }
                    SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.enumeration(inputStreams));
                    if (totalSize <= 0x200000L) {
                        try {
                            response = BinaryTransferTestOuterClass.EchoBinariesObservably_Responses.newBuilder().setJointBinary(SiLABinary.fromBytes((ByteString)ByteString.readFrom((InputStream)sequenceInputStream))).build();
                        }
                        catch (IOException e) {
                            throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.UNRECOGNIZED, (String)"");
                        }
                    }
                    UUID newBinaryUUID = UUID.randomUUID();
                    try {
                        binaryDatabase.addBinary(newBinaryUUID, (InputStream)sequenceInputStream, "org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinariesObservably/Parameter/Binaries");
                        response = BinaryTransferTestOuterClass.EchoBinariesObservably_Responses.newBuilder().setJointBinary(SiLABinary.fromBinaryTransferUUID((UUID)newBinaryUUID)).build();
                    }
                    catch (BinaryDatabaseException e) {
                        throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.UNRECOGNIZED, (String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinariesObservably/Parameter/Binaries");
                    }
                    for (int i = 0; i < binaries.size(); ++i) {
                        SiLAFramework.Binary binary = binaries.get(i);
                        command.setExecutionInfoAndNotify((double)i / ((double)binaries.size() - 1.0), Duration.ofSeconds(4L));
                        command.notifyIntermediateResponse((Object)BinaryTransferTestOuterClass.EchoBinariesObservably_IntermediateResponses.newBuilder().setBinary(binary).build());
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    BinaryTransferTestOuterClass.EchoBinariesObservably_Responses echoBinariesObservably_Responses = response;
                    return echoBinariesObservably_Responses;
                }
                finally {
                    BinaryTransferTest.silentlyCloseInputStreams(inputStreams);
                }
            }

            public void validate(BinaryTransferTestOuterClass.EchoBinariesObservably_Parameters parameters) throws StatusRuntimeException {
                if (parameters.getBinariesList().isEmpty()) {
                    throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinariesObservably/Parameter/Binaries", (String)"Empty Binaries parameter.");
                }
                parameters.getBinariesList().forEach(b -> {
                    block5: {
                        if (b.hasBinaryTransferUUID()) {
                            try {
                                if (!binaryDatabase.hasBinary(UUID.fromString(b.getBinaryTransferUUID()))) {
                                    throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinariesObservably/Parameter/Binaries", (String)"Invalid Binary Transfer UUID");
                                }
                                break block5;
                            }
                            catch (Exception e) {
                                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinariesObservably/Parameter/Binaries", (String)"Invalid Binary Transfer UUID");
                            }
                        }
                        if (!b.hasValue()) {
                            throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinariesObservably/Parameter/Binaries", (String)"Empty Binary value.");
                        }
                    }
                });
            }
        }, Duration.ofSeconds(60L));
    }

    @Override
    public void echoBinaryValue(BinaryTransferTestOuterClass.EchoBinaryValue_Parameters request, StreamObserver<BinaryTransferTestOuterClass.EchoBinaryValue_Responses> responseObserver) {
        block6: {
            if (!request.hasBinaryValue()) {
                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryValue/Parameter/BinaryValue", (String)"Missing BinaryValue parameter.");
            }
            if (request.getBinaryValue().hasBinaryTransferUUID()) {
                try {
                    if (!this.binaryDatabase.hasBinary(UUID.fromString(request.getBinaryValue().getBinaryTransferUUID()))) {
                        throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryValue/Parameter/BinaryValue", (String)"Invalid Binary Transfer UUID");
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryValue/Parameter/BinaryValue", (String)"Invalid Binary Transfer UUID");
                }
            }
            if (!request.getBinaryValue().hasValue()) {
                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryValue/Parameter/BinaryValue", (String)"Empty BinaryValue parameter.");
            }
        }
        responseObserver.onNext((Object)BinaryTransferTestOuterClass.EchoBinaryValue_Responses.newBuilder().setReceivedValue(request.getBinaryValue()).build());
        responseObserver.onCompleted();
    }

    @Override
    public void echoBinariesObservably(BinaryTransferTestOuterClass.EchoBinariesObservably_Parameters request, StreamObserver<SiLAFramework.CommandConfirmation> responseObserver) {
        this.echoBinaryCommandManager.addCommand((Object)request, responseObserver);
    }

    @Override
    public void echoBinariesObservablyInfo(SiLAFramework.CommandExecutionUUID request, StreamObserver<SiLAFramework.ExecutionInfo> responseObserver) {
        this.echoBinaryCommandManager.get(request).addStateObserver(responseObserver);
    }

    @Override
    public void echoBinariesObservablyIntermediate(SiLAFramework.CommandExecutionUUID request, StreamObserver<BinaryTransferTestOuterClass.EchoBinariesObservably_IntermediateResponses> responseObserver) {
        this.echoBinaryCommandManager.get(request).addIntermediateResponseObserver(responseObserver);
    }

    @Override
    public void echoBinariesObservablyResult(SiLAFramework.CommandExecutionUUID request, StreamObserver<BinaryTransferTestOuterClass.EchoBinariesObservably_Responses> responseObserver) {
        this.echoBinaryCommandManager.get(request).sendResult(responseObserver);
    }

    @Override
    public void echoBinaryAndMetadataString(BinaryTransferTestOuterClass.EchoBinaryAndMetadataString_Parameters request, StreamObserver<BinaryTransferTestOuterClass.EchoBinaryAndMetadataString_Responses> responseObserver) {
        BinaryTransferTestOuterClass.Metadata_String metadataString;
        block8: {
            ServerMetadataContainer serverMetadataContainer = (ServerMetadataContainer)MetadataExtractingInterceptor.SILA_METADATA_KEY.get();
            try {
                metadataString = (BinaryTransferTestOuterClass.Metadata_String)serverMetadataContainer.get(BinaryTransferTestOuterClass.Metadata_String.class);
            }
            catch (Exception e) {
                throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_METADATA, (String)"Malformed metadata.");
            }
            if (metadataString == null || !metadataString.hasString()) {
                throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_METADATA, (String)"Expect a metadata.");
            }
            if (request.hasBinary() && request.getBinary().hasBinaryTransferUUID()) {
                try {
                    if (!this.binaryDatabase.hasBinary(UUID.fromString(request.getBinary().getBinaryTransferUUID()))) {
                        throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString/Parameter/Binary", (String)"Invalid Binary Transfer UUID");
                    }
                    break block8;
                }
                catch (Exception e) {
                    throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString/Parameter/Binary", (String)"Invalid Binary Transfer UUID");
                }
            }
            if (!request.hasBinary() || !request.getBinary().hasValue()) {
                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString/Parameter/Binary", (String)"Empty Binary value.");
            }
        }
        responseObserver.onNext((Object)BinaryTransferTestOuterClass.EchoBinaryAndMetadataString_Responses.newBuilder().setBinary(request.getBinary()).setStringMetadata(metadataString.getString()).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getBinaryValueDirectly(BinaryTransferTestOuterClass.Get_BinaryValueDirectly_Parameters request, StreamObserver<BinaryTransferTestOuterClass.Get_BinaryValueDirectly_Responses> responseObserver) {
        responseObserver.onNext((Object)BinaryTransferTestOuterClass.Get_BinaryValueDirectly_Responses.newBuilder().setBinaryValueDirectly(SiLABinary.fromBytes((ByteString)ByteString.copyFrom((String)"SiLA2_Test_String_Value", (Charset)StandardCharsets.UTF_8))).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getBinaryValueDownload(BinaryTransferTestOuterClass.Get_BinaryValueDownload_Parameters request, StreamObserver<BinaryTransferTestOuterClass.Get_BinaryValueDownload_Responses> responseObserver) {
        byte[] data = Strings.repeat((String)"A_slightly_longer_SiLA2_Test_String_Value_used_to_demonstrate_the_binary_download", (int)100000).getBytes(StandardCharsets.UTF_8);
        UUID newBinaryUUID = UUID.randomUUID();
        try {
            this.binaryDatabase.addBinary(newBinaryUUID, data, "org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString/Parameter/Binary");
        }
        catch (BinaryDatabaseException e) {
            throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)"");
        }
        responseObserver.onNext((Object)BinaryTransferTestOuterClass.Get_BinaryValueDownload_Responses.newBuilder().setBinaryValueDownload(SiLABinary.fromBinaryTransferUUID((UUID)newBinaryUUID)).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getFCPAffectedByMetadataString(BinaryTransferTestOuterClass.Get_FCPAffectedByMetadata_String_Parameters request, StreamObserver<BinaryTransferTestOuterClass.Get_FCPAffectedByMetadata_String_Responses> responseObserver) {
        responseObserver.onNext((Object)BinaryTransferTestOuterClass.Get_FCPAffectedByMetadata_String_Responses.newBuilder().addAllAffectedCalls(Collections.singletonList(SiLAString.from((String)"org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString"))).build());
        responseObserver.onCompleted();
    }

    private static void silentlyCloseInputStreams(List<InputStream> inputStreams) {
        for (InputStream inputStream : inputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

