/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.server.features;

import io.grpc.stub.StreamObserver;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.test.authenticationtest.v1.AuthenticationTestGrpc;
import sila2.org.silastandard.test.authenticationtest.v1.AuthenticationTestOuterClass;
import sila_java.library.core.sila.errors.SiLAErrorException;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.server_base.binary_transfer.Binary;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;
import sila_java.library.server_base.standard_features.v1.AuthorizationController;

public class AuthenticationTest
extends AuthenticationTestGrpc.AuthenticationTestImplBase {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationTest.class);
    private final BinaryDatabase binaryDatabase;
    private final AuthorizationController.Authorize authorize;

    @Override
    public void requiresToken(AuthenticationTestOuterClass.RequiresToken_Parameters request, StreamObserver<AuthenticationTestOuterClass.RequiresToken_Responses> responseObserver) {
        try {
            this.authorize.authorize("org.silastandard/test/AuthenticationTest/v1");
        }
        catch (SiLAErrorException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)AuthenticationTestOuterClass.RequiresToken_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void requiresTokenForBinaryUpload(AuthenticationTestOuterClass.RequiresTokenForBinaryUpload_Parameters request, StreamObserver<AuthenticationTestOuterClass.RequiresTokenForBinaryUpload_Responses> responseObserver) {
        try {
            this.authorize.authorize("org.silastandard/test/AuthenticationTest/v1");
        }
        catch (SiLAErrorException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        if (!request.hasBinaryToUpload()) {
            responseObserver.onError((Throwable)SiLAErrors.generateValidationError((String)"org.silastandard/test/AuthenticationTest/v1/Command/RequiresTokenForBinaryUpload/Parameter/BinaryToUpload", (String)"Missing parameter 'Binary To Upload'."));
            return;
        }
        if (request.getBinaryToUpload().hasBinaryTransferUUID()) {
            try {
                Binary e = this.binaryDatabase.getBinary(UUID.fromString(request.getBinaryToUpload().getBinaryTransferUUID()));
            }
            catch (BinaryDatabaseException e) {
                log.error("Error during binary transfer", (Throwable)e);
                responseObserver.onError((Throwable)SiLAErrors.generateUndefinedExecutionError((String)"Error during binary transfer"));
                return;
            }
        }
        responseObserver.onNext((Object)AuthenticationTestOuterClass.RequiresTokenForBinaryUpload_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    public AuthenticationTest(BinaryDatabase binaryDatabase, AuthorizationController.Authorize authorize) {
        this.binaryDatabase = binaryDatabase;
        this.authorize = authorize;
    }
}

