/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.cloudier.client.CloudierClientEndpoint;
import sila_java.library.core.sila.errors.SiLAErrorException;
import sila_java.library.core.sila.types.SiLAString;

public class CloudierClientObserver
implements StreamObserver<SiLACloudConnector.SiLAServerMessage>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CloudierClientObserver.class);
    private final StreamObserver<SiLACloudConnector.SiLAClientMessage> responseObserver;
    private final CloudierClientEndpoint.CloudServerListener cloudServerListener;
    private final Map<String, CloudierClientEndpoint.MessageListener> messageListeners = new ConcurrentHashMap<String, CloudierClientEndpoint.MessageListener>();
    private Optional<UUID> optionalServerUUID = Optional.empty();

    public CloudierClientObserver(StreamObserver<SiLACloudConnector.SiLAClientMessage> responseObserver, CloudierClientEndpoint.CloudServerListener cloudServerListener) {
        this.responseObserver = responseObserver;
        this.cloudServerListener = cloudServerListener;
    }

    @Override
    public void close() {
        this.responseObserver.onCompleted();
        this.cloudServerListener.onEnd(this.optionalServerUUID, Optional.empty());
    }

    public CompletableFuture<ByteString> runObservableCommand(SiLACloudConnector.CommandParameter parameter, String fullyQualifiedCommandId, boolean hasIntermediateResponse, CloudierClientEndpoint.CallListener callListener) {
        String uuid = UUID.randomUUID().toString();
        CompletableCancelableFuture<ByteString> result = new CompletableCancelableFuture<ByteString>(() -> {
            this.messageListeners.remove(uuid);
            if (hasIntermediateResponse) {
                this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setCancelObservableCommandIntermediateResponseSubscription(SiLACloudConnector.CancelObservableCommandIntermediateResponseSubscription.newBuilder().build()).build());
            }
            this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setCancelObservableCommandExecutionInfoSubscription(SiLACloudConnector.CancelObservableCommandExecutionInfoSubscription.newBuilder().build()).build());
        });
        AtomicReference<Object> commandExecUUID = new AtomicReference<Object>(null);
        this.messageListeners.put(uuid, message -> {
            if (message.hasObservableCommandConfirmation()) {
                commandExecUUID.set(message.getObservableCommandConfirmation().getCommandConfirmation().getCommandExecutionUUID());
                if (hasIntermediateResponse) {
                    this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setObservableCommandIntermediateResponseSubscription(SiLACloudConnector.ObservableCommandIntermediateResponseSubscription.newBuilder().setCommandExecutionUUID((SiLAFramework.CommandExecutionUUID)commandExecUUID.get()).build()).build());
                }
                this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setObservableCommandExecutionInfoSubscription(SiLACloudConnector.ObservableCommandExecutionInfoSubscription.newBuilder().setCommandExecutionUUID((SiLAFramework.CommandExecutionUUID)commandExecUUID.get()).build()).build());
                callListener.onCommandInit(message.getObservableCommandConfirmation());
            } else if (message.hasCommandError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getCommandError()));
                callListener.onError(message.getCommandError());
            } else if (message.hasObservableCommandExecutionInfo()) {
                SiLAFramework.ExecutionInfo.CommandStatus status = message.getObservableCommandExecutionInfo().getExecutionInfo().getCommandStatus();
                callListener.onCommandExecutionInfo(message.getObservableCommandExecutionInfo());
                if (status == SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError || status == SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully) {
                    this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setObservableCommandGetResponse(SiLACloudConnector.ObservableCommandGetResponse.newBuilder().setCommandExecutionUUID((SiLAFramework.CommandExecutionUUID)commandExecUUID.get()).build()).build());
                }
            } else if (message.hasObservableCommandIntermediateResponse()) {
                callListener.onIntermediateResponse(message.getObservableCommandIntermediateResponse());
            } else if (message.hasObservableCommandResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getObservableCommandResponse().getResponse());
            } else {
                log.warn("Unknown response {} for observable command {}", (Object)message.getMessageCase(), (Object)uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setObservableCommandInitiation(SiLACloudConnector.ObservableCommandInitiation.newBuilder().setCommandParameter(parameter).setFullyQualifiedCommandId(fullyQualifiedCommandId).build()).build());
        return result;
    }

    public <ParameterType extends GeneratedMessageV3, ResponseType> CompletableFuture<ResponseType> runUnobservableCommand(String fullyQualifiedId, ParameterType parameter, Parser<ResponseType> parser) {
        return this.runUnobservableCommand(SiLACloudConnector.UnobservableCommandExecution.newBuilder().setFullyQualifiedCommandId(fullyQualifiedId).setCommandParameter(SiLACloudConnector.CommandParameter.newBuilder().setParameters(parameter.toByteString()).build()).build(), parser);
    }

    public <ResponseType> CompletableFuture<ResponseType> runUnobservableCommand(SiLACloudConnector.UnobservableCommandExecution commandExecution, Parser<ResponseType> parser) {
        return this.runUnobservableCommand(commandExecution).thenApply(byteString -> {
            try {
                return parser.parseFrom(byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Invalid message received", e);
            }
        });
    }

    public CompletableFuture<ByteString> runUnobservableCommand(SiLACloudConnector.UnobservableCommandExecution commandExecution) {
        String uuid = UUID.randomUUID().toString();
        CompletableCancelableFuture<ByteString> result = new CompletableCancelableFuture<ByteString>(() -> this.messageListeners.remove(uuid));
        this.messageListeners.put(uuid, message -> {
            if (message.hasUnobservableCommandResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getUnobservableCommandResponse().getResponse());
            } else if (message.hasCommandError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getCommandError()));
            } else {
                log.warn("Unknown response {} for unobservable command {}", (Object)message.getMessageCase(), (Object)uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setUnobservableCommandExecution(commandExecution).build());
        return result;
    }

    public CompletableFuture<ByteString> readObservableProperty(SiLACloudConnector.ObservablePropertySubscription propertySubscription, Function<ByteString, Boolean> responseCallback) {
        String uuid = UUID.randomUUID().toString();
        CompletableCancelableFuture<ByteString> result = new CompletableCancelableFuture<ByteString>(() -> {
            this.messageListeners.remove(uuid);
            this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setCancelObservablePropertySubscription(SiLACloudConnector.CancelObservablePropertySubscription.newBuilder().build()).build());
        });
        this.messageListeners.put(uuid, message -> {
            if (message.hasObservablePropertyValue()) {
                boolean keepReading = (Boolean)responseCallback.apply(message.getObservablePropertyValue().getValue());
                if (!keepReading) {
                    result.complete(message.getObservablePropertyValue().getValue());
                }
            } else if (message.hasPropertyError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getPropertyError()));
            } else {
                log.warn("Unknown response for observable property " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setObservablePropertySubscription(propertySubscription).build());
        return result;
    }

    public <ResponseType> CompletableFuture<ResponseType> readUnobservableProperty(String fullyQualifiedId, Parser<ResponseType> parser) {
        return this.readUnobservableProperty(SiLACloudConnector.UnobservablePropertyRead.newBuilder().setFullyQualifiedPropertyId(fullyQualifiedId).build(), parser);
    }

    public <ResponseType> CompletableFuture<ResponseType> readUnobservableProperty(SiLACloudConnector.UnobservablePropertyRead propertyRead, Parser<ResponseType> parser) {
        return this.readUnobservableProperty(propertyRead).thenApply(byteString -> {
            try {
                return parser.parseFrom(byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Invalid message received", e);
            }
        });
    }

    public CompletableFuture<ByteString> readUnobservableProperty(SiLACloudConnector.UnobservablePropertyRead propertyRead) {
        String uuid = UUID.randomUUID().toString();
        CompletableCancelableFuture<ByteString> result = new CompletableCancelableFuture<ByteString>(() -> this.messageListeners.remove(uuid));
        this.messageListeners.put(uuid, message -> {
            if (message.hasUnobservablePropertyValue()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getUnobservablePropertyValue().getValue());
            } else if (message.hasPropertyError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getPropertyError()));
            } else {
                log.warn("Unknown response for unobservable property " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setUnobservablePropertyRead(propertyRead).build());
        return result;
    }

    public CompletableFuture<SiLACloudConnector.GetFCPAffectedByMetadataResponse> getFCPAffectedByMetadata(String fullyQualifiedMetadataId) {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<SiLACloudConnector.GetFCPAffectedByMetadataResponse> result = new CompletableFuture<SiLACloudConnector.GetFCPAffectedByMetadataResponse>();
        this.messageListeners.put(uuid, message -> {
            if (message.hasGetFCPAffectedByMetadataResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getGetFCPAffectedByMetadataResponse());
            } else if (message.hasCommandError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getCommandError()));
            } else {
                log.warn("Unknown response for command " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setMetadataRequest(SiLACloudConnector.GetFCPAffectedByMetadataRequest.newBuilder().setFullyQualifiedMetadataId(fullyQualifiedMetadataId).build()).build());
        return result;
    }

    public CompletableFuture<SiLABinaryTransfer.CreateBinaryResponse> createBinaryUploadRequest(SiLABinaryTransfer.CreateBinaryRequest createBinaryRequest, Set<SiLACloudConnector.Metadata> metadata) {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<SiLABinaryTransfer.CreateBinaryResponse> result = new CompletableFuture<SiLABinaryTransfer.CreateBinaryResponse>();
        this.messageListeners.put(uuid, message -> {
            if (message.hasCreateBinaryResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getCreateBinaryResponse());
            } else if (message.hasBinaryTransferError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getBinaryTransferError()));
            } else {
                log.warn("Unknown response for command " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setCreateBinaryUploadRequest(SiLACloudConnector.CreateBinaryUploadRequest.newBuilder().addAllMetadata(metadata).setCreateBinaryRequest(createBinaryRequest).build()).build());
        return result;
    }

    public CompletableFuture<SiLABinaryTransfer.DeleteBinaryResponse> deleteDownloadedBinaryRequest(SiLABinaryTransfer.DeleteBinaryRequest deleteBinaryRequest) {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<SiLABinaryTransfer.DeleteBinaryResponse> result = new CompletableFuture<SiLABinaryTransfer.DeleteBinaryResponse>();
        this.messageListeners.put(uuid, message -> {
            if (message.hasDeleteBinaryResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getDeleteBinaryResponse());
            } else if (message.hasBinaryTransferError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getBinaryTransferError()));
            } else {
                log.warn("Unknown response for command " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setDeleteDownloadedBinaryRequest(deleteBinaryRequest).build());
        return result;
    }

    public CompletableFuture<SiLABinaryTransfer.DeleteBinaryResponse> deleteUploadedBinaryRequest(SiLABinaryTransfer.DeleteBinaryRequest deleteBinaryRequest) {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<SiLABinaryTransfer.DeleteBinaryResponse> result = new CompletableFuture<SiLABinaryTransfer.DeleteBinaryResponse>();
        this.messageListeners.put(uuid, message -> {
            if (message.hasDeleteBinaryResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getDeleteBinaryResponse());
            } else if (message.hasBinaryTransferError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getBinaryTransferError()));
            } else {
                log.warn("Unknown response for command " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setDeleteUploadedBinaryRequest(deleteBinaryRequest).build());
        return result;
    }

    public CompletableFuture<SiLABinaryTransfer.UploadChunkResponse> uploadBinaryChunkRequest(SiLABinaryTransfer.UploadChunkRequest uploadChunkRequest) {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<SiLABinaryTransfer.UploadChunkResponse> result = new CompletableFuture<SiLABinaryTransfer.UploadChunkResponse>();
        this.messageListeners.put(uuid, message -> {
            if (message.hasUploadChunkResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getUploadChunkResponse());
            } else if (message.hasBinaryTransferError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getBinaryTransferError()));
            } else {
                log.warn("Unknown response for command " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setUploadChunkRequest(uploadChunkRequest).build());
        return result;
    }

    public CompletableFuture<SiLABinaryTransfer.GetBinaryInfoResponse> getBinaryInfoResponseRequest(SiLABinaryTransfer.GetBinaryInfoRequest binaryInfoRequest) {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<SiLABinaryTransfer.GetBinaryInfoResponse> result = new CompletableFuture<SiLABinaryTransfer.GetBinaryInfoResponse>();
        this.messageListeners.put(uuid, message -> {
            if (message.hasGetBinaryResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getGetBinaryResponse());
            } else if (message.hasBinaryTransferError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getBinaryTransferError()));
            } else {
                log.warn("Unknown response for command " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setGetBinaryInfoRequest(binaryInfoRequest).build());
        return result;
    }

    public CompletableFuture<SiLABinaryTransfer.GetChunkResponse> getBinaryChunkRequest(SiLABinaryTransfer.GetChunkRequest chunkRequest) {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<SiLABinaryTransfer.GetChunkResponse> result = new CompletableFuture<SiLABinaryTransfer.GetChunkResponse>();
        this.messageListeners.put(uuid, message -> {
            if (message.hasGetChunkResponse()) {
                this.messageListeners.remove(uuid);
                result.complete(message.getGetChunkResponse());
            } else if (message.hasBinaryTransferError()) {
                this.messageListeners.remove(uuid);
                result.obtrudeException((Throwable)new SiLAErrorException(message.getBinaryTransferError()));
            } else {
                log.warn("Unknown response for command " + uuid);
            }
        });
        this.responseObserver.onNext((Object)SiLACloudConnector.SiLAClientMessage.newBuilder().setRequestUUID(uuid).setGetChunkRequest(chunkRequest).build());
        return result;
    }

    public CompletableFuture<SiLAServiceOuterClass.Get_ServerUUID_Responses> getOptionalServerUUID() {
        return this.readUnobservableProperty("org.silastandard/core/SiLAService/v1/Property/ServerUUID", SiLAServiceOuterClass.Get_ServerUUID_Responses.parser());
    }

    public CompletableFuture<SiLAServiceOuterClass.Get_ServerType_Responses> getServerType() {
        return this.readUnobservableProperty("org.silastandard/core/SiLAService/v1/Property/ServerType", SiLAServiceOuterClass.Get_ServerType_Responses.parser());
    }

    public CompletableFuture<SiLAServiceOuterClass.Get_ServerName_Responses> getServerName() {
        return this.readUnobservableProperty("org.silastandard/core/SiLAService/v1/Property/ServerName", SiLAServiceOuterClass.Get_ServerName_Responses.parser());
    }

    public CompletableFuture<SiLAServiceOuterClass.Get_ServerDescription_Responses> getServerDescription() {
        return this.readUnobservableProperty("org.silastandard/core/SiLAService/v1/Property/ServerDescription", SiLAServiceOuterClass.Get_ServerDescription_Responses.parser());
    }

    public CompletableFuture<SiLAServiceOuterClass.Get_ServerVersion_Responses> getServerVersion() {
        return this.readUnobservableProperty("org.silastandard/core/SiLAService/v1/Property/ServerVersion", SiLAServiceOuterClass.Get_ServerVersion_Responses.parser());
    }

    public CompletableFuture<SiLAServiceOuterClass.Get_ServerVendorURL_Responses> getServerVendorUrl() {
        return this.readUnobservableProperty("org.silastandard/core/SiLAService/v1/Property/ServerVendorURL", SiLAServiceOuterClass.Get_ServerVendorURL_Responses.parser());
    }

    public CompletableFuture<SiLAServiceOuterClass.Get_ImplementedFeatures_Responses> getServerImplementedFeatures() {
        return this.readUnobservableProperty("org.silastandard/core/SiLAService/v1/Property/ImplementedFeatures", SiLAServiceOuterClass.Get_ImplementedFeatures_Responses.parser());
    }

    public CompletableFuture<SiLAServiceOuterClass.GetFeatureDefinition_Responses> getServerImplementedFeatures(String featureId) {
        return this.runUnobservableCommand("org.silastandard/core/SiLAService/v1/Command/GetFeatureDefinition", SiLAServiceOuterClass.GetFeatureDefinition_Parameters.newBuilder().setFeatureIdentifier(SiLAString.from((String)featureId)).build(), SiLAServiceOuterClass.GetFeatureDefinition_Responses.parser());
    }

    public void onNext(SiLACloudConnector.SiLAServerMessage silaServerMessage) {
        log.debug("Cloud message received " + silaServerMessage.getMessageCase().name());
        this.messageListeners.getOrDefault(silaServerMessage.getRequestUUID(), message -> log.warn("Unhandled response received for request " + message.getRequestUUID())).onMessage(silaServerMessage);
    }

    public void onError(Throwable throwable) {
        this.cloudServerListener.onEnd(this.optionalServerUUID, Optional.ofNullable(throwable));
    }

    public void onCompleted() {
        this.cloudServerListener.onEnd(this.optionalServerUUID, Optional.empty());
    }

    public void setServerUUID(UUID serverUUIDValue) {
        this.optionalServerUUID = Optional.ofNullable(serverUUIDValue);
    }

    public CloudierClientObserver(StreamObserver<SiLACloudConnector.SiLAClientMessage> responseObserver, CloudierClientEndpoint.CloudServerListener cloudServerListener, Optional<UUID> optionalServerUUID) {
        this.responseObserver = responseObserver;
        this.cloudServerListener = cloudServerListener;
        this.optionalServerUUID = optionalServerUUID;
    }

    public static class CompletableCancelableFuture<T>
    extends CompletableFuture<T> {
        private final Runnable onCancel;

        public CompletableCancelableFuture(@NonNull Runnable onCancel) {
            if (onCancel == null) {
                throw new NullPointerException("onCancel is marked non-null but is null");
            }
            this.onCancel = onCancel;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                this.onCancel.run();
            }
            catch (Throwable e) {
                log.warn("Exception occurred while cancelling future", e);
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

