/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.StreamObserver;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.BinaryDownloadGrpc;
import sila2.org.silastandard.BinaryUploadGrpc;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLACloudConnector;
import sila_java.library.cloudier.server.CallMessageMap;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierRequest;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.cloudier.server.IBinaryMessageHandler;
import sila_java.library.cloudier.server.IMetadataMessageHandler;
import sila_java.library.cloudier.server.IObservableCommandMessageHandler;
import sila_java.library.cloudier.server.IObservablePropertyMessageHandler;
import sila_java.library.cloudier.server.IUnobservableCommandMessageHandler;
import sila_java.library.cloudier.server.IUnobservablePropertyMessageHandler;
import sila_java.library.cloudier.server.MessageCaseHandler;
import sila_java.library.cloudier.server.SynchronizedStreamObserver;
import sila_java.library.cloudier.server.impl.BinaryMessageHandler;
import sila_java.library.cloudier.server.impl.MetadataMessageHandler;
import sila_java.library.cloudier.server.impl.ObservableCommandMessageHandler;
import sila_java.library.cloudier.server.impl.ObservablePropertyMessageHandler;
import sila_java.library.cloudier.server.impl.UnobservableCommandMessageHandler;
import sila_java.library.cloudier.server.impl.UnobservablePropertyMessageHandler;

public class CloudierServerEndpoint
implements StreamObserver<SiLACloudConnector.SiLAClientMessage> {
    private static final Logger log = LoggerFactory.getLogger(CloudierServerEndpoint.class);
    private final CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> streamObserver;
    private final CloudierSiLAService cloudierSiLAService;
    private final CloudierConnectionConfigurationService cloudierConnectionConfigurationService;
    private final IMetadataMessageHandler metadataHandler;
    private final IBinaryMessageHandler binaryHandler;
    private final IUnobservableCommandMessageHandler unobservableCommandHandler;
    private final IObservableCommandMessageHandler observableCommandHandler;
    private final IUnobservablePropertyMessageHandler unobservablePropertyHandler;
    private final IObservablePropertyMessageHandler observablePropertyHandler;
    private final CallMessageMap callMessageMap;
    private final EnumMap<SiLACloudConnector.SiLAClientMessage.MessageCase, Consumer<SiLACloudConnector.SiLAClientMessage>> callback = new EnumMap(SiLACloudConnector.SiLAClientMessage.MessageCase.class);

    public CloudierServerEndpoint(CloudierSiLAService cloudierSiLAService, CloudierConnectionConfigurationService cloudierConnectionConfigurationService, CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint, Map<String, MessageCaseHandler> callForwarderMap) {
        this(cloudierSiLAService, cloudierConnectionConfigurationService, clientEndpoint, callForwarderMap, null, null);
    }

    public CloudierServerEndpoint(CloudierSiLAService cloudierSiLAService, CloudierConnectionConfigurationService cloudierConnectionConfigurationService, CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint, Map<String, MessageCaseHandler> callForwarderMap, @Nullable BinaryUploadGrpc.BinaryUploadImplBase uploadImplBase, @Nullable BinaryDownloadGrpc.BinaryDownloadImplBase downloadImplBase) {
        this.cloudierConnectionConfigurationService = cloudierConnectionConfigurationService;
        this.cloudierSiLAService = cloudierSiLAService;
        this.clientEndpoint = clientEndpoint;
        this.callMessageMap = new CallMessageMap(cloudierSiLAService, cloudierConnectionConfigurationService, callForwarderMap, uploadImplBase, downloadImplBase);
        this.streamObserver = new SynchronizedStreamObserver<SiLACloudConnector.SiLAServerMessage>(clientEndpoint.connectSiLAServer((StreamObserver)this));
        this.metadataHandler = new MetadataMessageHandler(this.streamObserver, this.callMessageMap);
        this.binaryHandler = new BinaryMessageHandler(this.streamObserver, this.callMessageMap);
        this.unobservableCommandHandler = new UnobservableCommandMessageHandler(this.streamObserver, this.callMessageMap);
        this.observableCommandHandler = new ObservableCommandMessageHandler(this.streamObserver, this.callMessageMap);
        this.unobservablePropertyHandler = new UnobservablePropertyMessageHandler(this.streamObserver, this.callMessageMap);
        this.observablePropertyHandler = new ObservablePropertyMessageHandler(this.streamObserver, this.callMessageMap);
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDINITIATION, message -> this.observableCommandHandler.onCommandInit(new CloudierRequest<SiLACloudConnector.ObservableCommandInitiation>(message.getRequestUUID(), message.getObservableCommandInitiation())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDINTERMEDIATERESPONSESUBSCRIPTION, message -> this.observableCommandHandler.onIntermediate(new CloudierRequest<SiLACloudConnector.ObservableCommandIntermediateResponseSubscription>(message.getRequestUUID(), message.getObservableCommandIntermediateResponseSubscription())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDEXECUTIONINFOSUBSCRIPTION, message -> this.observableCommandHandler.onCommandExecInfo(new CloudierRequest<SiLACloudConnector.ObservableCommandExecutionInfoSubscription>(message.getRequestUUID(), message.getObservableCommandExecutionInfoSubscription())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDGETRESPONSE, message -> this.observableCommandHandler.onResult(new CloudierRequest<SiLACloudConnector.ObservableCommandGetResponse>(message.getRequestUUID(), message.getObservableCommandGetResponse())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.UNOBSERVABLECOMMANDEXECUTION, message -> this.unobservableCommandHandler.onCommandExec(new CloudierRequest<SiLACloudConnector.UnobservableCommandExecution>(message.getRequestUUID(), message.getUnobservableCommandExecution())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.UNOBSERVABLEPROPERTYREAD, message -> this.unobservablePropertyHandler.onUnobservableProperty(new CloudierRequest<SiLACloudConnector.UnobservablePropertyRead>(message.getRequestUUID(), message.getUnobservablePropertyRead())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLEPROPERTYSUBSCRIPTION, message -> this.observablePropertyHandler.onObservableProperty(new CloudierRequest<SiLACloudConnector.ObservablePropertySubscription>(message.getRequestUUID(), message.getObservablePropertySubscription())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.CANCELOBSERVABLEPROPERTYSUBSCRIPTION, message -> this.observablePropertyHandler.onCancelObservableProperty(new CloudierRequest<SiLACloudConnector.CancelObservablePropertySubscription>(message.getRequestUUID(), message.getCancelObservablePropertySubscription())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.METADATAREQUEST, message -> this.metadataHandler.onGetAffectedByMetadata(new CloudierRequest<SiLACloudConnector.GetFCPAffectedByMetadataRequest>(message.getRequestUUID(), message.getMetadataRequest())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.CANCELOBSERVABLECOMMANDEXECUTIONINFOSUBSCRIPTION, message -> this.observableCommandHandler.onCancelExecInfo(new CloudierRequest<SiLACloudConnector.CancelObservableCommandExecutionInfoSubscription>(message.getRequestUUID(), message.getCancelObservableCommandExecutionInfoSubscription())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.CANCELOBSERVABLECOMMANDINTERMEDIATERESPONSESUBSCRIPTION, message -> this.observableCommandHandler.onCancelIntermediate(new CloudierRequest<SiLACloudConnector.CancelObservableCommandIntermediateResponseSubscription>(message.getRequestUUID(), message.getCancelObservableCommandIntermediateResponseSubscription())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.CREATEBINARYUPLOADREQUEST, message -> this.binaryHandler.onCreateBinaryUpload(new CloudierRequest<SiLACloudConnector.CreateBinaryUploadRequest>(message.getRequestUUID(), message.getCreateBinaryUploadRequest())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.DELETEDOWNLOADEDBINARYREQUEST, message -> this.binaryHandler.onDeleteBinaryDownload(new CloudierRequest<SiLABinaryTransfer.DeleteBinaryRequest>(message.getRequestUUID(), message.getDeleteDownloadedBinaryRequest())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.DELETEUPLOADEDBINARYREQUEST, message -> this.binaryHandler.onDeleteBinaryUpload(new CloudierRequest<SiLABinaryTransfer.DeleteBinaryRequest>(message.getRequestUUID(), message.getDeleteUploadedBinaryRequest())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.UPLOADCHUNKREQUEST, message -> this.binaryHandler.onUploadChunk(new CloudierRequest<SiLABinaryTransfer.UploadChunkRequest>(message.getRequestUUID(), message.getUploadChunkRequest())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.GETBINARYINFOREQUEST, message -> this.binaryHandler.onBinaryInfo(new CloudierRequest<SiLABinaryTransfer.GetBinaryInfoRequest>(message.getRequestUUID(), message.getGetBinaryInfoRequest())));
        this.callback.put(SiLACloudConnector.SiLAClientMessage.MessageCase.GETCHUNKREQUEST, message -> this.binaryHandler.onGetChunk(new CloudierRequest<SiLABinaryTransfer.GetChunkRequest>(message.getRequestUUID(), message.getGetChunkRequest())));
    }

    public void onNext(SiLACloudConnector.SiLAClientMessage silaClientMessage) {
        CompletableFuture.runAsync(() -> {
            log.warn("new message received " + silaClientMessage.getMessageCase().name());
            Consumer<SiLACloudConnector.SiLAClientMessage> callback = this.callback.get(silaClientMessage.getMessageCase());
            if (callback != null) {
                callback.accept(silaClientMessage);
            } else {
                log.info("Unhandled message " + silaClientMessage.getMessageCase().name());
            }
        });
    }

    public void onError(Throwable throwable) {
        log.warn("received error", throwable);
    }

    public void onCompleted() {
        log.warn("call ended");
    }

    public static interface AsyncCloudCallHandler<ParameterType extends GeneratedMessageV3, ResponseType> {
        public StreamObserver<ParameterType> handle(StreamObserver<ResponseType> var1);
    }

    public static interface CloudCallHandler<ParameterType extends GeneratedMessageV3, ResponseType> {
        public void handle(ParameterType var1, StreamObserver<ResponseType> var2);
    }
}

