/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.cloudier.server.CallMessageMap;
import sila_java.library.cloudier.server.CloudierRequest;
import sila_java.library.cloudier.server.IBinaryMessageHandler;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.errors.SiLAErrors;

public class BinaryMessageHandler
implements IBinaryMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(BinaryMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;
    private final CallMessageMap callMessageMap;

    public BinaryMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response, CallMessageMap callMessageMap) {
        this.response = response;
        this.callMessageMap = callMessageMap;
    }

    @Override
    public void onCreateBinaryUpload(CloudierRequest<SiLACloudConnector.CreateBinaryUploadRequest> request) {
        Optional binaryCallHandler = this.callMessageMap.getBinaryCallHandler(SiLACloudConnector.SiLAClientMessage.MessageCase.CREATEBINARYUPLOADREQUEST);
        if (binaryCallHandler.isPresent()) {
            log.info("Forwarding call for binary create upload");
            binaryCallHandler.get().forward(request.getRequestUUID(), request.getRequest().getMetadataList(), request.getRequest().getCreateBinaryRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setCreateBinaryResponse(message).build()), throwable -> this.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.sendUnknownBinaryTransferCallError(request.getRequestUUID(), "Create binary upload request");
        }
    }

    @Override
    public void onUploadChunk(CloudierRequest<SiLABinaryTransfer.UploadChunkRequest> request) {
        Optional binaryCallHandler = this.callMessageMap.getBinaryCallHandler(SiLACloudConnector.SiLAClientMessage.MessageCase.UPLOADCHUNKREQUEST);
        if (binaryCallHandler.isPresent()) {
            log.info("Forwarding call for binary chunk upload");
            binaryCallHandler.get().forward(request.getRequestUUID(), request.getRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setUploadChunkResponse(message).build()), throwable -> this.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.sendUnknownBinaryTransferCallError(request.getRequestUUID(), "Upload chunk request");
        }
    }

    @Override
    public void onBinaryInfo(CloudierRequest<SiLABinaryTransfer.GetBinaryInfoRequest> request) {
        Optional binaryCallHandler = this.callMessageMap.getBinaryCallHandler(SiLACloudConnector.SiLAClientMessage.MessageCase.GETBINARYINFOREQUEST);
        if (binaryCallHandler.isPresent()) {
            log.info("Forwarding call for binary info");
            binaryCallHandler.get().forward(request.getRequestUUID(), request.getRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setGetBinaryResponse(message).build()), throwable -> this.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.sendUnknownBinaryTransferCallError(request.getRequestUUID(), "Get binary info request");
        }
    }

    @Override
    public void onGetChunk(CloudierRequest<SiLABinaryTransfer.GetChunkRequest> request) {
        Optional binaryCallHandler = this.callMessageMap.getBinaryCallHandler(SiLACloudConnector.SiLAClientMessage.MessageCase.GETCHUNKREQUEST);
        if (binaryCallHandler.isPresent()) {
            log.info("Forwarding call for binary get chunk");
            binaryCallHandler.get().forward(request.getRequestUUID(), request.getRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setGetChunkResponse(message).build()), throwable -> this.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.sendUnknownBinaryTransferCallError(request.getRequestUUID(), "Get chunk request");
        }
    }

    @Override
    public void onDeleteBinaryDownload(CloudierRequest<SiLABinaryTransfer.DeleteBinaryRequest> request) {
        Optional binaryCallHandler = this.callMessageMap.getBinaryCallHandler(SiLACloudConnector.SiLAClientMessage.MessageCase.DELETEDOWNLOADEDBINARYREQUEST);
        if (binaryCallHandler.isPresent()) {
            log.info("Forwarding call for binary delete download");
            binaryCallHandler.get().forward(request.getRequestUUID(), request.getRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setDeleteBinaryResponse(message).build()), throwable -> this.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.sendUnknownBinaryTransferCallError(request.getRequestUUID(), "Delete downloaded binary request");
        }
    }

    @Override
    public void onDeleteBinaryUpload(CloudierRequest<SiLABinaryTransfer.DeleteBinaryRequest> request) {
        Optional binaryCallHandler = this.callMessageMap.getBinaryCallHandler(SiLACloudConnector.SiLAClientMessage.MessageCase.DELETEUPLOADEDBINARYREQUEST);
        if (binaryCallHandler.isPresent()) {
            log.info("Forwarding call for binary delete ulpoad");
            binaryCallHandler.get().forward(request.getRequestUUID(), request.getRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setDeleteBinaryResponse(message).build()), throwable -> this.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.sendUnknownBinaryTransferCallError(request.getRequestUUID(), "Delete uploaded binary request");
        }
    }

    public void sendSiLABinaryError(String requestUuid, SiLABinaryTransfer.BinaryTransferError error) {
        this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(requestUuid).setBinaryTransferError(error).build());
    }

    public void sendThrowableError(String requestUuid, Throwable error) {
        Optional optional;
        log.info("Error occurred with request {}, {}", (Object)requestUuid, (Object)error);
        SiLABinaryTransfer.BinaryTransferError binaryTransferError = null;
        if (error instanceof StatusRuntimeException && (optional = BinaryTransferErrorHandler.retrieveBinaryTransferError((StatusRuntimeException)((StatusRuntimeException)error))).isPresent()) {
            binaryTransferError = (SiLABinaryTransfer.BinaryTransferError)optional.get();
        }
        if (binaryTransferError == null) {
            SiLAFramework.SiLAError siLAError = SiLAErrors.throwableToSiLAError((Throwable)error);
            String errorMessage = siLAError.hasValidationError() ? siLAError.getValidationError().getMessage() : (siLAError.hasFrameworkError() ? siLAError.getFrameworkError().getMessage() : (siLAError.hasDefinedExecutionError() ? siLAError.getDefinedExecutionError().getMessage() : (siLAError.hasUndefinedExecutionError() ? siLAError.getUndefinedExecutionError().getMessage() : "Unknown error: " + error.getMessage())));
            binaryTransferError = SiLABinaryTransfer.BinaryTransferError.newBuilder().setErrorType(SiLABinaryTransfer.BinaryTransferError.ErrorType.UNRECOGNIZED).setMessage(errorMessage).build();
        }
        this.sendSiLABinaryError(requestUuid, binaryTransferError);
    }

    public void sendUnknownBinaryTransferCallError(String requestUuid, String name) {
        log.warn("Client with request {} attempted to call unknown binary transfer {}", (Object)requestUuid, (Object)name);
        this.sendSiLABinaryError(requestUuid, SiLABinaryTransfer.BinaryTransferError.newBuilder().setMessage("Server does not expose binary transfer call to " + name).setErrorType(SiLABinaryTransfer.BinaryTransferError.ErrorType.UNRECOGNIZED).build());
    }
}

