/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.errors.SiLAErrors;

public class CommandMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(CommandMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;

    public void sendSiLAError(String requestUuid, SiLAFramework.SiLAError error) {
        this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(requestUuid).setCommandError(error).build());
    }

    public void sendThrowableError(String requestUuid, Throwable error) {
        log.info("Error occurred with request {}, {}", (Object)requestUuid, (Object)error);
        this.sendSiLAError(requestUuid, SiLAErrors.throwableToSiLAError((Throwable)error));
    }

    public void sendUnknownCommandError(String requestUuid, String fqi) {
        log.warn("Client with request {} attempted to call an unknown command {}", (Object)requestUuid, (Object)fqi);
        this.sendSiLAError(requestUuid, SiLAFramework.SiLAError.newBuilder().setUndefinedExecutionError(SiLAFramework.UndefinedExecutionError.newBuilder().setMessage("Server does not expose command with id " + fqi).build()).build());
    }

    public CommandMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response) {
        this.response = response;
    }
}

