/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila_java.library.cloudier.server.CallMessageMap;
import sila_java.library.cloudier.server.CloudierRequest;
import sila_java.library.cloudier.server.IObservablePropertyMessageHandler;
import sila_java.library.cloudier.server.impl.PropertyMessageHandler;

public class ObservablePropertyMessageHandler
implements IObservablePropertyMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(ObservablePropertyMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;
    private final CallMessageMap callMessageMap;
    private final PropertyMessageHandler propertyMessageHandler;
    private final Map<String, String> uuidToFqiMap = new HashMap<String, String>();

    public ObservablePropertyMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response, CallMessageMap callMessageMap) {
        this.response = response;
        this.callMessageMap = callMessageMap;
        this.propertyMessageHandler = new PropertyMessageHandler(response);
    }

    @Override
    public void onObservableProperty(CloudierRequest<SiLACloudConnector.ObservablePropertySubscription> request) {
        String fqi = request.getRequest().getFullyQualifiedPropertyId();
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLEPROPERTYSUBSCRIPTION);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            this.uuidToFqiMap.put(request.getRequestUUID(), fqi);
            callHandler.get().forward(request.getRequestUUID(), request.getRequest().getMetadataList(), request.getRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setObservablePropertyValue(SiLACloudConnector.ObservablePropertyValue.newBuilder().setValue(message.toByteString()).build()).build()), throwable -> this.propertyMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.propertyMessageHandler.sendUnknownPropertyError(request.getRequestUUID(), fqi);
        }
    }

    @Override
    public void onCancelObservableProperty(CloudierRequest<SiLACloudConnector.CancelObservablePropertySubscription> request) {
        String fqi = this.uuidToFqiMap.get(request.getRequestUUID());
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLEPROPERTYSUBSCRIPTION);
        if (callHandler.isPresent()) {
            callHandler.get().cancelRequest(request.getRequestUUID());
            log.info("Subscription to observable property request {} cancelled", (Object)request.getRequestUUID());
        }
        this.uuidToFqiMap.remove(request.getRequestUUID());
    }
}

