/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.client;

import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.cloudier.client.CloudierClientEndpoint;
import sila_java.library.cloudier.client.CloudierClientObserver;
import sila_java.library.core.encryption.EncryptionUtils;
import sila_java.library.core.encryption.SelfSignedCertificate;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.core.utils.Utils;

public class CloudierClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CloudierClient.class);
    public static final int DEFAULT_PORT = 50051;
    private final Server server;
    private final CloudierClientEndpoint endpointService;

    public CloudierClient(CloudierClientEndpoint.CloudServerListener cloudServerListener) throws IOException, CertificateEncodingException, SelfSignedCertificate.CertificateGenerationException {
        this.endpointService = new CloudierClientEndpoint(cloudServerListener);
        SelfSignedCertificate selfSignedCertificate = SelfSignedCertificate.newBuilder().build();
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)50051).useTransportSecurity(EncryptionUtils.certificateToStream((X509Certificate)selfSignedCertificate.getCertificate()), EncryptionUtils.keyToStream((PrivateKey)selfSignedCertificate.getPrivateKey())).addService((BindableService)this.endpointService);
        this.server = serverBuilder.build();
        this.server.start();
        log.info("Cloudier client listening on port: 50051");
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException, TimeoutException, CertificateEncodingException, IOException, SelfSignedCertificate.CertificateGenerationException {
        CloudierClient cloudierClient = new CloudierClient(new CloudierClientEndpoint.CloudServerListener(){

            @Override
            public void onAdd(UUID serverUUID, CloudierClientObserver cloudierClientObserver) {
            }

            @Override
            public void onEnd(Optional<UUID> serverUUID, Optional<Throwable> t) {
            }
        });
        while (cloudierClient.endpointService.getResponseObservers().get("498edc02-f1b8-41c7-a337-39569ec4b2b3") == null) {
            Thread.sleep(100L);
        }
        CloudierClientObserver clientObserver = cloudierClient.endpointService.getResponseObservers().get("498edc02-f1b8-41c7-a337-39569ec4b2b3");
        CompletableFuture stringCompletableFuture = clientObserver.runUnobservableCommand("", SiLAString.from((String)""), SiLAFramework.String.parser());
        SiLAFramework.String s = (SiLAFramework.String)stringCompletableFuture.get(60L, TimeUnit.SECONDS);
        log.info("received " + s.getValue());
        CompletableFuture property = clientObserver.readUnobservableProperty("", SiLAFramework.String.parser());
        s = (SiLAFramework.String)property.get(60L, TimeUnit.SECONDS);
        log.info("received " + s.getValue());
        CompletableFuture<ByteString> obs = clientObserver.runObservableCommand(SiLACloudConnector.CommandParameter.newBuilder().build(), "", true, new CloudierClientEndpoint.CallListener(){

            @Override
            public void onCommandInit(SiLACloudConnector.ObservableCommandConfirmation observableCommandConfirmation) {
                log.info("Command init " + observableCommandConfirmation.getCommandConfirmation().getCommandExecutionUUID().getValue());
            }

            @Override
            public void onCommandExecutionInfo(SiLACloudConnector.ObservableCommandExecutionInfo observableCommandExecutionInfo) {
                log.info("Command status " + observableCommandExecutionInfo.getExecutionInfo().getCommandStatus().name());
            }

            @Override
            public void onIntermediateResponse(SiLACloudConnector.ObservableCommandIntermediateResponse observableCommandExecutionInfo) {
                log.info("Intermediate response: " + SiLAFramework.String.parseFrom((ByteString)observableCommandExecutionInfo.getResponse()).getValue());
            }

            @Override
            public void onError(SiLAFramework.SiLAError siLAError) {
                log.info("On error " + siLAError.toString());
            }
        });
        ByteString b = obs.get(60L, TimeUnit.SECONDS);
        log.info("received " + SiLAFramework.String.parseFrom((ByteString)b).getValue());
        CompletableFuture<ByteString> obsproperty = clientObserver.readObservableProperty(SiLACloudConnector.ObservablePropertySubscription.newBuilder().setFullyQualifiedPropertyId("").build(), r -> false);
        b = obsproperty.get(60L, TimeUnit.SECONDS);
        log.info("received " + SiLAFramework.String.parseFrom((ByteString)b).getValue());
        if (!clientObserver.getOptionalServerUUID().get(60L, TimeUnit.SECONDS).getServerUUID().getValue().equals("498edc02-f1b8-41c7-a337-39569ec4b2b3")) {
            throw new RuntimeException("UUID does not match");
        }
        if (!clientObserver.getServerDescription().get(60L, TimeUnit.SECONDS).getServerDescription().getValue().equals("Test")) {
            throw new RuntimeException("Description does not match");
        }
        if (!clientObserver.getServerName().get(60L, TimeUnit.SECONDS).getServerName().getValue().equals("sila-test")) {
            throw new RuntimeException("Name does not match");
        }
        if (!clientObserver.getServerType().get(60L, TimeUnit.SECONDS).getServerType().getValue().equals("cloud-test")) {
            throw new RuntimeException("Type does not match");
        }
        if (!clientObserver.getServerVendorUrl().get(60L, TimeUnit.SECONDS).getServerVendorURL().getValue().equals("com.timothy.diguiet")) {
            throw new RuntimeException("URL does not match");
        }
        if (!clientObserver.getServerVersion().get(60L, TimeUnit.SECONDS).getServerVersion().getValue().equals("0.0")) {
            throw new RuntimeException("Version does not match");
        }
        log.info("To stop the client press CTRL + C.");
        Utils.blockUntilShutdown(cloudierClient::close);
    }

    @Override
    public void close() {
        try {
            this.server.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Server closing interrupted", (Throwable)e);
        }
    }

    public CloudierClientEndpoint getEndpointService() {
        return this.endpointService;
    }
}

