/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server;

import com.google.protobuf.GeneratedMessageV3;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.NonNull;
import sila2.org.silastandard.BinaryDownloadGrpc;
import sila2.org.silastandard.BinaryUploadGrpc;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.core.connectionconfigurationservice.v1.ConnectionConfigurationServiceOuterClass;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.cloudier.server.CloudCallForwarder;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.cloudier.server.MessageCaseHandler;

public class CallMessageMap {
    public final String SILA_BINARY_TRANSFER_FQI = "SiLABinaryTransfer";
    private final Map<String, MessageCaseHandler> callForwarderMap;

    public CallMessageMap(@NonNull CloudierSiLAService cloudierSiLAService, @NonNull CloudierConnectionConfigurationService cloudierConnectionConfigurationService, @NonNull Map<String, MessageCaseHandler> callForwarderMap) {
        this(cloudierSiLAService, cloudierConnectionConfigurationService, callForwarderMap, null, null);
        if (cloudierSiLAService == null) {
            throw new NullPointerException("cloudierSiLAService is marked non-null but is null");
        }
        if (cloudierConnectionConfigurationService == null) {
            throw new NullPointerException("cloudierConnectionConfigurationService is marked non-null but is null");
        }
        if (callForwarderMap == null) {
            throw new NullPointerException("callForwarderMap is marked non-null but is null");
        }
    }

    public CallMessageMap(final @NonNull CloudierSiLAService cloudierSiLAService, final @NonNull CloudierConnectionConfigurationService cloudierConnectionConfigurationService, @NonNull Map<String, MessageCaseHandler> callForwarderMap, final @Nullable BinaryUploadGrpc.BinaryUploadImplBase uploadImplBase, final @Nullable BinaryDownloadGrpc.BinaryDownloadImplBase downloadImplBase) {
        if (cloudierSiLAService == null) {
            throw new NullPointerException("cloudierSiLAService is marked non-null but is null");
        }
        if (cloudierConnectionConfigurationService == null) {
            throw new NullPointerException("cloudierConnectionConfigurationService is marked non-null but is null");
        }
        if (callForwarderMap == null) {
            throw new NullPointerException("callForwarderMap is marked non-null but is null");
        }
        this.callForwarderMap = new HashMap<String, MessageCaseHandler>();
        this.callForwarderMap.putAll(callForwarderMap);
        if (uploadImplBase != null && downloadImplBase != null) {
            this.callForwarderMap.putAll((Map<String, MessageCaseHandler>)new HashMap<String, MessageCaseHandler>(){
                {
                    this.put("SiLABinaryTransfer", new MessageCaseHandler().with(SiLACloudConnector.SiLAClientMessage.MessageCase.CREATEBINARYUPLOADREQUEST, SiLABinaryTransfer.CreateBinaryRequest.parser(), (arg_0, arg_1) -> ((BinaryUploadGrpc.BinaryUploadImplBase)uploadImplBase).createBinary(arg_0, arg_1)).with(SiLACloudConnector.SiLAClientMessage.MessageCase.DELETEUPLOADEDBINARYREQUEST, SiLABinaryTransfer.DeleteBinaryRequest.parser(), (arg_0, arg_1) -> ((BinaryUploadGrpc.BinaryUploadImplBase)uploadImplBase).deleteBinary(arg_0, arg_1)).withAsync(SiLACloudConnector.SiLAClientMessage.MessageCase.UPLOADCHUNKREQUEST, SiLABinaryTransfer.UploadChunkRequest.parser(), arg_0 -> ((BinaryUploadGrpc.BinaryUploadImplBase)uploadImplBase).uploadChunk(arg_0)).with(SiLACloudConnector.SiLAClientMessage.MessageCase.DELETEDOWNLOADEDBINARYREQUEST, SiLABinaryTransfer.DeleteBinaryRequest.parser(), (arg_0, arg_1) -> ((BinaryDownloadGrpc.BinaryDownloadImplBase)downloadImplBase).deleteBinary(arg_0, arg_1)).with(SiLACloudConnector.SiLAClientMessage.MessageCase.GETBINARYINFOREQUEST, SiLABinaryTransfer.GetBinaryInfoRequest.parser(), (arg_0, arg_1) -> ((BinaryDownloadGrpc.BinaryDownloadImplBase)downloadImplBase).getBinaryInfo(arg_0, arg_1)).withAsync(SiLACloudConnector.SiLAClientMessage.MessageCase.GETCHUNKREQUEST, SiLABinaryTransfer.GetChunkRequest.parser(), arg_0 -> ((BinaryDownloadGrpc.BinaryDownloadImplBase)downloadImplBase).getChunk(arg_0)));
                }
            });
        }
        this.callForwarderMap.putAll((Map<String, MessageCaseHandler>)new HashMap<String, MessageCaseHandler>(){
            {
                this.put("org.silastandard/core/SiLAService/v1/Property/ServerUUID", new MessageCaseHandler().withUnobservableProperty(SiLAServiceOuterClass.Get_ServerUUID_Parameters.parser(), cloudierSiLAService::getServerUUID));
                this.put("org.silastandard/core/SiLAService/v1/Property/ServerName", new MessageCaseHandler().withUnobservableProperty(SiLAServiceOuterClass.Get_ServerName_Parameters.parser(), cloudierSiLAService::getServerName));
                this.put("org.silastandard/core/SiLAService/v1/Property/ServerDescription", new MessageCaseHandler().withUnobservableProperty(SiLAServiceOuterClass.Get_ServerDescription_Parameters.parser(), cloudierSiLAService::getServerDescription));
                this.put("org.silastandard/core/SiLAService/v1/Property/ServerVendorURL", new MessageCaseHandler().withUnobservableProperty(SiLAServiceOuterClass.Get_ServerVendorURL_Parameters.parser(), cloudierSiLAService::getServerVendorURL));
                this.put("org.silastandard/core/SiLAService/v1/Property/ServerType", new MessageCaseHandler().withUnobservableProperty(SiLAServiceOuterClass.Get_ServerType_Parameters.parser(), cloudierSiLAService::getServerType));
                this.put("org.silastandard/core/SiLAService/v1/Property/ServerVersion", new MessageCaseHandler().withUnobservableProperty(SiLAServiceOuterClass.Get_ServerVersion_Parameters.parser(), cloudierSiLAService::getServerVersion));
                this.put("org.silastandard/core/SiLAService/v1/Property/ImplementedFeatures", new MessageCaseHandler().withUnobservableProperty(SiLAServiceOuterClass.Get_ImplementedFeatures_Parameters.parser(), cloudierSiLAService::getImplementedFeatures));
                this.put("org.silastandard/core/SiLAService/v1/Command/GetFeatureDefinition", new MessageCaseHandler().withUnobservableCommand(SiLAServiceOuterClass.GetFeatureDefinition_Parameters.parser(), cloudierSiLAService::getFeatureDefinition));
                this.put("org.silastandard/core/SiLAService/v1/Command/SetServerName", new MessageCaseHandler().withUnobservableCommand(SiLAServiceOuterClass.SetServerName_Parameters.parser(), cloudierSiLAService::setServerName));
                this.put("org.silastandard/core/ConnectionConfigurationService/v1/Command/EnableServerInitiatedConnectionMode", new MessageCaseHandler().withUnobservableCommand(ConnectionConfigurationServiceOuterClass.EnableServerInitiatedConnectionMode_Parameters.parser(), cloudierConnectionConfigurationService::enableServerInitiatedConnectionMode));
                this.put("org.silastandard/core/ConnectionConfigurationService/v1/Command/DisableServerInitiatedConnectionMode", new MessageCaseHandler().withUnobservableCommand(ConnectionConfigurationServiceOuterClass.DisableServerInitiatedConnectionMode_Parameters.parser(), cloudierConnectionConfigurationService::disableServerInitiatedConnectionMode));
                this.put("org.silastandard/core/ConnectionConfigurationService/v1/Command/ConnectSiLAClient", new MessageCaseHandler().withUnobservableCommand(ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Parameters.parser(), cloudierConnectionConfigurationService::connectSiLAClient));
                this.put("org.silastandard/core/ConnectionConfigurationService/v1/Command/DisconnectSiLAClient", new MessageCaseHandler().withUnobservableCommand(ConnectionConfigurationServiceOuterClass.DisconnectSiLAClient_Parameters.parser(), cloudierConnectionConfigurationService::disconnectSiLAClient));
                this.put("org.silastandard/core/ConnectionConfigurationService/v1/Property/ServerInitiatedConnectionModeStatus", new MessageCaseHandler().withUnobservableProperty(ConnectionConfigurationServiceOuterClass.Get_ServerInitiatedConnectionModeStatus_Parameters.parser(), cloudierConnectionConfigurationService::getServerInitiatedConnectionModeStatus));
                this.put("org.silastandard/core/ConnectionConfigurationService/v1/Property/ConfiguredSiLAClients", new MessageCaseHandler().withUnobservableProperty(ConnectionConfigurationServiceOuterClass.Get_ConfiguredSiLAClients_Parameters.parser(), cloudierConnectionConfigurationService::getConfiguredSiLAClients));
            }
        });
    }

    public Optional<MessageCaseHandler> getMessageHandler(String fullyQualifiedCallId) {
        return Optional.ofNullable(this.callForwarderMap.get(fullyQualifiedCallId));
    }

    public <RequestType extends GeneratedMessageV3, ResponseType extends GeneratedMessageV3> Optional<CloudCallForwarder<RequestType, ResponseType>> getBinaryCallHandler(SiLACloudConnector.SiLAClientMessage.MessageCase messageCase) {
        MessageCaseHandler messageCaseHandler = this.callForwarderMap.get("SiLABinaryTransfer");
        if (messageCaseHandler != null) {
            return messageCaseHandler.get(messageCase);
        }
        return Optional.empty();
    }

    public <RequestType extends GeneratedMessageV3, ResponseType extends GeneratedMessageV3> Optional<CloudCallForwarder<RequestType, ResponseType>> getCallHandler(String fullyQualifiedCallId, SiLACloudConnector.SiLAClientMessage.MessageCase messageCase) {
        MessageCaseHandler messageCaseHandler = this.callForwarderMap.get(fullyQualifiedCallId);
        if (messageCaseHandler != null) {
            return messageCaseHandler.get(messageCase);
        }
        return Optional.empty();
    }
}

