/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.client;

import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.cloudier.client.CloudierClientObserver;
import sila_java.library.cloudier.server.SynchronizedStreamObserver;

public class CloudierClientEndpoint
extends CloudClientEndpointGrpc.CloudClientEndpointImplBase {
    private static final Logger log = LoggerFactory.getLogger(CloudierClientEndpoint.class);
    private final Map<String, CloudierClientObserver> responseObservers = new ConcurrentHashMap<String, CloudierClientObserver>();
    private final CloudServerListener cloudServerListener;

    public CloudierClientEndpoint(CloudServerListener cloudServerListener) {
        this.cloudServerListener = cloudServerListener;
    }

    public StreamObserver<SiLACloudConnector.SiLAServerMessage> connectSiLAServer(StreamObserver<SiLACloudConnector.SiLAClientMessage> responseObserver) {
        log.info("new server connected");
        CloudierClientObserver cloudierClientObserver = new CloudierClientObserver(new SynchronizedStreamObserver<SiLACloudConnector.SiLAClientMessage>(responseObserver), this.cloudServerListener);
        cloudierClientObserver.getOptionalServerUUID().whenComplete((serverUUID, ex) -> {
            if (ex != null) {
                log.warn("Failed to add server because server did not provide a valid uuid", ex);
                responseObserver.onCompleted();
                return;
            }
            log.info("server connected with uuid " + serverUUID.getServerUUID());
            UUID serverUUIDValue = UUID.fromString(serverUUID.getServerUUID().getValue());
            cloudierClientObserver.setServerUUID(serverUUIDValue);
            this.responseObservers.put(serverUUIDValue.toString(), cloudierClientObserver);
            this.cloudServerListener.onAdd(serverUUIDValue, cloudierClientObserver);
        });
        return cloudierClientObserver;
    }

    public Map<String, CloudierClientObserver> getResponseObservers() {
        return this.responseObservers;
    }

    public static interface CallListener {
        public void onCommandInit(SiLACloudConnector.ObservableCommandConfirmation var1);

        public void onCommandExecutionInfo(SiLACloudConnector.ObservableCommandExecutionInfo var1);

        public void onIntermediateResponse(SiLACloudConnector.ObservableCommandIntermediateResponse var1);

        public void onError(SiLAFramework.SiLAError var1);
    }

    public static interface CloudServerListener {
        public void onAdd(UUID var1, CloudierClientObserver var2);

        public void onEnd(Optional<UUID> var1, Optional<Throwable> var2);
    }

    @FunctionalInterface
    public static interface MessageListener {
        public void onMessage(SiLACloudConnector.SiLAServerMessage var1);
    }
}

