/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Parser;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.core.sila.utils.FullQualifierUtils;
import sila_java.library.server_base.Constants;
import sila_java.library.server_base.FullyQualifiedMetadataContextKey;

public class CloudCallForwarder<ParameterType extends GeneratedMessageV3, ResponseType extends GeneratedMessageV3> {
    private static final Logger log = LoggerFactory.getLogger(CloudCallForwarder.class);
    private final Parser<ParameterType> parser;
    private final CloudierServerEndpoint.CloudCallHandler<ParameterType, ResponseType> cloudCallHandler;
    private final CloudierServerEndpoint.AsyncCloudCallHandler<ParameterType, ResponseType> asyncCloudCallHandler;
    private final Map<String, Observer> runningRequests = new HashMap<String, Observer>();

    public CloudCallForwarder(Parser<ParameterType> parser, CloudierServerEndpoint.CloudCallHandler<ParameterType, ResponseType> cloudCallHandler) {
        this.parser = parser;
        this.cloudCallHandler = cloudCallHandler;
        this.asyncCloudCallHandler = null;
    }

    public CloudCallForwarder(Parser<ParameterType> parser, CloudierServerEndpoint.AsyncCloudCallHandler<ParameterType, ResponseType> asyncCloudCallHandler) {
        this.parser = parser;
        this.asyncCloudCallHandler = asyncCloudCallHandler;
        this.cloudCallHandler = null;
    }

    public void cancelRequest(String requestUuid) {
        Observer observer = this.runningRequests.get(requestUuid);
        if (observer != null) {
            log.info("Cancelled request {}", (Object)requestUuid);
            observer.onError((Throwable)new StatusRuntimeException(Status.CANCELLED));
        }
        if (this.runningRequests.containsKey(requestUuid)) {
            log.warn("Running request still running after calling onError");
            this.runningRequests.remove(requestUuid);
        }
    }

    public CompletableFuture<ResponseType> forward(String requestUuid, ByteString request, Consumer<ResponseType> onNextCallback, Consumer<Throwable> onErrorCallback) {
        return this.forward(requestUuid, Collections.emptyList(), request, onNextCallback, onErrorCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ResponseType> forward(String requestUuid, List<SiLACloudConnector.Metadata> metadataSet, ByteString request, Consumer<ResponseType> onNextCallback, Consumer<Throwable> onErrorCallback) {
        CompletableFuture completableFuture;
        block9: {
            completableFuture = new CompletableFuture();
            try {
                if (this.runningRequests.containsKey(requestUuid)) {
                    throw new RuntimeException("Request with uuid " + requestUuid + " already exist");
                }
                Observer responseTypeObserver = new Observer(completableFuture, this.runningRequests, requestUuid, onNextCallback, onErrorCallback);
                this.runningRequests.put(requestUuid, responseTypeObserver);
                GeneratedMessageV3 parameter = (GeneratedMessageV3)this.parser.parseFrom(request);
                HashSet<FullyQualifiedMetadataContextKey> keySet = new HashSet<FullyQualifiedMetadataContextKey>();
                Context contextWithMetadata = Context.current();
                for (SiLACloudConnector.Metadata metadata : metadataSet) {
                    String keyIdentifier = FullQualifierUtils.metadataHeader((String)metadata.getFullyQualifiedMetadataId());
                    FullyQualifiedMetadataContextKey contextKey = new FullyQualifiedMetadataContextKey(metadata.getFullyQualifiedMetadataId(), Context.key((String)keyIdentifier));
                    keySet.add(contextKey);
                    contextWithMetadata = contextWithMetadata.withValue(contextKey.getContextKey(), (Object)metadata.getValue().toByteArray());
                }
                contextWithMetadata = contextWithMetadata.withValue(Constants.METADATA_IDENTIFIERS_CTX_KEY, keySet);
                Context initialContext = contextWithMetadata.attach();
                try {
                    if (this.cloudCallHandler != null) {
                        this.cloudCallHandler.handle(parameter, responseTypeObserver);
                    } else {
                        StreamObserver<ParameterType> parameterObserver = this.asyncCloudCallHandler.handle(responseTypeObserver);
                        parameterObserver.onNext((Object)parameter);
                        parameterObserver.onCompleted();
                    }
                }
                finally {
                    contextWithMetadata.detach(initialContext);
                }
            }
            catch (Throwable e) {
                this.cancelRequest(requestUuid);
                if (completableFuture.isDone()) break block9;
                completableFuture.obtrudeException(e);
                onErrorCallback.accept(e);
            }
        }
        return completableFuture;
    }

    public Parser<ParameterType> getParser() {
        return this.parser;
    }

    public CloudierServerEndpoint.CloudCallHandler<ParameterType, ResponseType> getCloudCallHandler() {
        return this.cloudCallHandler;
    }

    public CloudierServerEndpoint.AsyncCloudCallHandler<ParameterType, ResponseType> getAsyncCloudCallHandler() {
        return this.asyncCloudCallHandler;
    }

    public Map<String, Observer> getRunningRequests() {
        return this.runningRequests;
    }

    public static class Observer<Type>
    implements StreamObserver<Type> {
        private final CompletableFuture<Type> completableFuture;
        private final AtomicReference<Type> lastResponse;
        private final Map<String, Observer> runningRequests;
        private final String requestUuid;
        private final Consumer<Type> onNextCallback;
        private final Consumer<Throwable> onErrorCallback;

        Observer(@NonNull CompletableFuture<Type> completableFuture, @NonNull Map<String, Observer> runningRequests, String requestUuid, @NonNull Consumer<Type> onNextCallback, @NonNull Consumer<Throwable> onErrorCallback) {
            if (completableFuture == null) {
                throw new NullPointerException("completableFuture is marked non-null but is null");
            }
            if (runningRequests == null) {
                throw new NullPointerException("runningRequests is marked non-null but is null");
            }
            if (onNextCallback == null) {
                throw new NullPointerException("onNextCallback is marked non-null but is null");
            }
            if (onErrorCallback == null) {
                throw new NullPointerException("onErrorCallback is marked non-null but is null");
            }
            this.completableFuture = completableFuture;
            this.lastResponse = new AtomicReference<Object>(null);
            this.runningRequests = runningRequests;
            this.requestUuid = requestUuid;
            this.onNextCallback = onNextCallback;
            this.onErrorCallback = onErrorCallback;
        }

        public void onNext(Type responseType) {
            if (!this.runningRequests.containsKey(this.requestUuid)) {
                throw new StatusRuntimeException(Status.CANCELLED);
            }
            if (!this.completableFuture.isDone()) {
                this.lastResponse.set(responseType);
                this.onNextCallback.accept(responseType);
            }
        }

        public void onError(Throwable throwable) {
            this.runningRequests.remove(this.requestUuid);
            if (!this.completableFuture.isDone()) {
                this.onErrorCallback.accept(throwable);
                this.completableFuture.obtrudeException(throwable);
            }
        }

        public void onCompleted() {
            this.runningRequests.remove(this.requestUuid);
            if (!this.completableFuture.isDone()) {
                this.completableFuture.complete(this.lastResponse.get());
            }
        }
    }
}

