/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.cloudier.server.CallMessageMap;
import sila_java.library.cloudier.server.CloudierRequest;
import sila_java.library.cloudier.server.IMetadataMessageHandler;
import sila_java.library.cloudier.server.impl.CommandMessageHandler;

public class MetadataMessageHandler
implements IMetadataMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(MetadataMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;
    private final CallMessageMap callMessageMap;
    private final CommandMessageHandler commandMessageHandler;

    public MetadataMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response, CallMessageMap callMessageMap) {
        this.response = response;
        this.callMessageMap = callMessageMap;
        this.commandMessageHandler = new CommandMessageHandler(response);
    }

    @Override
    public void onGetAffectedByMetadata(CloudierRequest<SiLACloudConnector.GetFCPAffectedByMetadataRequest> request) {
        String fqi = request.getRequest().getFullyQualifiedMetadataId();
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.METADATAREQUEST);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            callHandler.get().forward(request.getRequestUUID(), ByteString.EMPTY, message -> {
                ArrayList fcpAffectedList = new ArrayList();
                Optional<Descriptors.FieldDescriptor> optionalFieldDescriptor = message.getAllFields().keySet().stream().filter(f -> f.isRepeated() && f.getName().equals("AffectedCalls")).findAny();
                optionalFieldDescriptor.ifPresent(fieldDescriptor -> {
                    int count = message.getRepeatedFieldCount(fieldDescriptor);
                    for (int i = 0; i < count; ++i) {
                        Object fcpAffected = message.getRepeatedField(fieldDescriptor, i);
                        if (fcpAffected instanceof SiLAFramework.String) {
                            fcpAffectedList.add(((SiLAFramework.String)fcpAffected).getValue());
                            continue;
                        }
                        log.warn("Invalid FCP Affected By Metadata value {}", fcpAffected);
                    }
                });
                this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setGetFCPAffectedByMetadataResponse(SiLACloudConnector.GetFCPAffectedByMetadataResponse.newBuilder().addAllAffectedCalls(fcpAffectedList).build()).build());
            }, throwable -> this.commandMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.sendUnknownMetadataError(request.getRequestUUID(), fqi);
        }
    }

    public void sendUnknownMetadataError(String requestUuid, String fqi) {
        log.warn("Client with request {} attempted to call an unknown affected by metadata {}", (Object)requestUuid, (Object)fqi);
        this.commandMessageHandler.sendSiLAError(requestUuid, SiLAFramework.SiLAError.newBuilder().setUndefinedExecutionError(SiLAFramework.UndefinedExecutionError.newBuilder().setMessage("Server does not expose call to get affected by metadata with id " + fqi).build()).build());
    }
}

