/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import io.grpc.stub.StreamObserver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila_java.library.cloudier.server.CallMessageMap;
import sila_java.library.cloudier.server.CloudierRequest;
import sila_java.library.cloudier.server.IUnobservablePropertyMessageHandler;
import sila_java.library.cloudier.server.impl.PropertyMessageHandler;

public class UnobservablePropertyMessageHandler
implements IUnobservablePropertyMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(UnobservablePropertyMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;
    private final CallMessageMap callMessageMap;
    private final PropertyMessageHandler propertyMessageHandler;

    public UnobservablePropertyMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response, CallMessageMap callMessageMap) {
        this.response = response;
        this.callMessageMap = callMessageMap;
        this.propertyMessageHandler = new PropertyMessageHandler(response);
    }

    @Override
    public void onUnobservableProperty(CloudierRequest<SiLACloudConnector.UnobservablePropertyRead> request) {
        String fqi = request.getRequest().getFullyQualifiedPropertyId();
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.UNOBSERVABLEPROPERTYREAD);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            callHandler.get().forward(request.getRequestUUID(), request.getRequest().getMetadataList(), request.getRequest().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setUnobservablePropertyValue(SiLACloudConnector.UnobservablePropertyValue.newBuilder().setValue(message.toByteString()).build()).build()), throwable -> this.propertyMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.propertyMessageHandler.sendUnknownPropertyError(request.getRequestUUID(), fqi);
        }
    }
}

