/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server;

import com.google.common.collect.ImmutableMap;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.core.encryption.EncryptionUtils;
import sila_java.library.core.encryption.SelfSignedCertificate;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.sila_base.EmptyClass;

public class CloudierServer
implements CloudierConnectionConfigurationService.ConnectionConfigurationSwitch {
    private static final Logger log = LoggerFactory.getLogger(CloudierServer.class);
    public static final String serverUUID = "498edc02-f1b8-41c7-a337-39569ec4b2b3";
    public static final String serverDescription = "Test";
    public static final String serverVersion = "0.0";
    public static final String serverName = "sila-test";
    public static final String serverType = "cloud-test";
    public static final String serverURL = "com.timothy.diguiet";
    private final CloudierSiLAService cloudierSiLAService = new CloudierSiLAService("sila-test", "cloud-test", "498edc02-f1b8-41c7-a337-39569ec4b2b3", "0.0", "Test", "com.timothy.diguiet", (Map<String, String>)ImmutableMap.of((Object)"SiLAService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/SiLAService.sila.xml"))), (Object)"ConnectionConfigurationService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/ConnectionConfigurationService.sila.xml")))));
    private final CloudierConnectionConfigurationService cloudierConnectionConfigurationService = new CloudierConnectionConfigurationService(false, this);
    private ManagedChannel channel;
    private Server server;
    private CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private CloudierServerEndpoint cloudServerEndpointService;

    public static void main(String[] args) throws IOException {
        new CloudierServer();
        Utils.blockUntilStop();
    }

    public CloudierServer() throws IOException {
        this.startServerInitiatedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitch(boolean serverInitiatedConnectionEnabled) {
        log.info("server initiated turned " + (serverInitiatedConnectionEnabled ? "on" : "off"));
        if (serverInitiatedConnectionEnabled) {
            if (this.server != null) {
                try {
                    this.server.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.warn("Error while stopping server ", (Throwable)e);
                }
                finally {
                    this.server = null;
                }
            }
            this.startServerInitiatedConnection();
        } else {
            this.cloudServerEndpointService = null;
            this.clientEndpoint = null;
            if (this.channel != null) {
                try {
                    this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.warn("Error while closing channel ", (Throwable)e);
                }
                finally {
                    this.channel = null;
                }
            }
            this.startClientInitiatedConnection();
        }
    }

    private void startClientInitiatedConnection() {
        try {
            SelfSignedCertificate selfSignedCertificate = SelfSignedCertificate.newBuilder().withServerUUID(UUID.fromString(serverUUID)).withServerIP("127.0.0.1").build();
            this.server = ServerBuilder.forPort((int)50052).useTransportSecurity(EncryptionUtils.certificateToStream((X509Certificate)selfSignedCertificate.getCertificate()), EncryptionUtils.keyToStream((PrivateKey)selfSignedCertificate.getPrivateKey())).addService((BindableService)this.cloudierSiLAService).addService((BindableService)this.cloudierConnectionConfigurationService).build().start();
        }
        catch (Exception e) {
            log.error("Failed to start server ", (Throwable)e);
        }
    }

    private void startServerInitiatedConnection() {
        this.channel = ChannelFactory.getTLSEncryptedChannel((String)"localhost", (int)50051);
        this.clientEndpoint = CloudClientEndpointGrpc.newStub((Channel)this.channel);
        this.cloudServerEndpointService = new CloudierServerEndpoint(this.cloudierSiLAService, this.cloudierConnectionConfigurationService, this.clientEndpoint, Collections.emptyMap());
    }
}

