/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila_java.library.cloudier.server.CallMessageMap;
import sila_java.library.cloudier.server.CloudierRequest;
import sila_java.library.cloudier.server.IObservableCommandMessageHandler;
import sila_java.library.cloudier.server.impl.CommandMessageHandler;

public class ObservableCommandMessageHandler
implements IObservableCommandMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;
    private final CallMessageMap callMessageMap;
    private final CommandMessageHandler commandMessageHandler;
    private final Map<String, String> uuidToFqiMap = new HashMap<String, String>();

    public ObservableCommandMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response, CallMessageMap callMessageMap) {
        this.response = response;
        this.callMessageMap = callMessageMap;
        this.commandMessageHandler = new CommandMessageHandler(response);
    }

    @Override
    public void onCommandInit(CloudierRequest<SiLACloudConnector.ObservableCommandInitiation> request) {
        String fqi = request.getRequest().getFullyQualifiedCommandId();
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDINITIATION);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            this.uuidToFqiMap.put(request.getRequestUUID(), fqi);
            callHandler.get().forward(request.getRequestUUID(), request.getRequest().getCommandParameter().getMetadataList(), request.getRequest().getCommandParameter().getParameters(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setObservableCommandConfirmation(SiLACloudConnector.ObservableCommandConfirmation.newBuilder().setCommandConfirmation(message).build()).build()), throwable -> this.commandMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.commandMessageHandler.sendUnknownCommandError(request.getRequestUUID(), fqi);
        }
    }

    @Override
    public void onCommandExecInfo(CloudierRequest<SiLACloudConnector.ObservableCommandExecutionInfoSubscription> request) {
        String fqi = this.uuidToFqiMap.get(request.getRequestUUID());
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDEXECUTIONINFOSUBSCRIPTION);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            callHandler.get().forward(request.getRequestUUID(), request.getRequest().getCommandExecutionUUID().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setObservableCommandExecutionInfo(SiLACloudConnector.ObservableCommandExecutionInfo.newBuilder().setCommandExecutionUUID(((SiLACloudConnector.ObservableCommandExecutionInfoSubscription)request.getRequest()).getCommandExecutionUUID()).setExecutionInfo(message).build()).build()), throwable -> this.commandMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.commandMessageHandler.sendUnknownCommandError(request.getRequestUUID(), fqi);
        }
    }

    @Override
    public void onIntermediate(CloudierRequest<SiLACloudConnector.ObservableCommandIntermediateResponseSubscription> request) {
        String fqi = this.uuidToFqiMap.get(request.getRequestUUID());
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDINTERMEDIATERESPONSESUBSCRIPTION);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            callHandler.get().forward(request.getRequestUUID(), request.getRequest().getCommandExecutionUUID().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setObservableCommandIntermediateResponse(SiLACloudConnector.ObservableCommandIntermediateResponse.newBuilder().setCommandExecutionUUID(((SiLACloudConnector.ObservableCommandIntermediateResponseSubscription)request.getRequest()).getCommandExecutionUUID()).setResponse(message.toByteString()).build()).build()), throwable -> this.commandMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.commandMessageHandler.sendUnknownCommandError(request.getRequestUUID(), fqi);
        }
    }

    @Override
    public void onResult(CloudierRequest<SiLACloudConnector.ObservableCommandGetResponse> request) {
        String fqi = this.uuidToFqiMap.get(request.getRequestUUID());
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDGETRESPONSE);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            callHandler.get().forward(request.getRequestUUID(), request.getRequest().getCommandExecutionUUID().toByteString(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setObservableCommandResponse(SiLACloudConnector.ObservableCommandResponse.newBuilder().setCommandExecutionUUID(((SiLACloudConnector.ObservableCommandGetResponse)request.getRequest()).getCommandExecutionUUID()).setResponse(message.toByteString()).build()).build()), throwable -> this.commandMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.commandMessageHandler.sendUnknownCommandError(request.getRequestUUID(), fqi);
        }
    }

    @Override
    public void onCancelIntermediate(CloudierRequest<SiLACloudConnector.CancelObservableCommandIntermediateResponseSubscription> request) {
        String fqi = this.uuidToFqiMap.get(request.getRequestUUID());
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDINTERMEDIATERESPONSESUBSCRIPTION);
        if (callHandler.isPresent()) {
            callHandler.get().cancelRequest(request.getRequestUUID());
            log.info("Subscription to observable command intermediate response request {} cancelled", (Object)request.getRequestUUID());
        }
    }

    @Override
    public void onCancelExecInfo(CloudierRequest<SiLACloudConnector.CancelObservableCommandExecutionInfoSubscription> request) {
        String fqi = this.uuidToFqiMap.get(request.getRequestUUID());
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.OBSERVABLECOMMANDEXECUTIONINFOSUBSCRIPTION);
        if (callHandler.isPresent()) {
            callHandler.get().cancelRequest(request.getRequestUUID());
            log.info("Subscription to observable command execution info request {} cancelled", (Object)request.getRequestUUID());
        }
    }
}

