/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.errors.SiLAErrors;

public class PropertyMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(PropertyMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;

    public void sendSiLAError(String requestUuid, SiLAFramework.SiLAError error) {
        this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(requestUuid).setPropertyError(error).build());
    }

    public void sendThrowableError(String requestUuid, Throwable error) {
        this.sendSiLAError(requestUuid, SiLAErrors.throwableToSiLAError((Throwable)error));
    }

    public void sendUnknownPropertyError(String requestUuid, String fqi) {
        log.warn("Client with request {} attempted to call an unknown property {}", (Object)requestUuid, (Object)fqi);
        this.sendSiLAError(requestUuid, SiLAFramework.SiLAError.newBuilder().setUndefinedExecutionError(SiLAFramework.UndefinedExecutionError.newBuilder().setMessage("Server does not expose property with id " + fqi).build()).build());
    }

    public PropertyMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response) {
        this.response = response;
    }
}

