/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server.impl;

import io.grpc.stub.StreamObserver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLACloudConnector;
import sila_java.library.cloudier.server.CallMessageMap;
import sila_java.library.cloudier.server.CloudierRequest;
import sila_java.library.cloudier.server.IUnobservableCommandMessageHandler;
import sila_java.library.cloudier.server.impl.CommandMessageHandler;

public class UnobservableCommandMessageHandler
implements IUnobservableCommandMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(UnobservableCommandMessageHandler.class);
    private final StreamObserver<SiLACloudConnector.SiLAServerMessage> response;
    private final CallMessageMap callMessageMap;
    private final CommandMessageHandler commandMessageHandler;

    public UnobservableCommandMessageHandler(StreamObserver<SiLACloudConnector.SiLAServerMessage> response, CallMessageMap callMessageMap) {
        this.response = response;
        this.callMessageMap = callMessageMap;
        this.commandMessageHandler = new CommandMessageHandler(response);
    }

    @Override
    public void onCommandExec(CloudierRequest<SiLACloudConnector.UnobservableCommandExecution> request) {
        String fqi = request.getRequest().getFullyQualifiedCommandId();
        Optional callHandler = this.callMessageMap.getCallHandler(fqi, SiLACloudConnector.SiLAClientMessage.MessageCase.UNOBSERVABLECOMMANDEXECUTION);
        if (callHandler.isPresent()) {
            log.info("Forwarding call for " + fqi);
            callHandler.get().forward(request.getRequestUUID(), request.getRequest().getCommandParameter().getMetadataList(), request.getRequest().getCommandParameter().getParameters(), message -> this.response.onNext((Object)SiLACloudConnector.SiLAServerMessage.newBuilder().setRequestUUID(request.getRequestUUID()).setUnobservableCommandResponse(SiLACloudConnector.UnobservableCommandResponse.newBuilder().setResponse(message.toByteString()).build()).build()), throwable -> this.commandMessageHandler.sendThrowableError(request.getRequestUUID(), (Throwable)throwable));
        } else {
            this.commandMessageHandler.sendUnknownCommandError(request.getRequestUUID(), fqi);
        }
    }
}

