/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.cloudier.server;

import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.core.connectionconfigurationservice.v1.ConnectionConfigurationServiceGrpc;
import sila2.org.silastandard.core.connectionconfigurationservice.v1.ConnectionConfigurationServiceOuterClass;
import sila_java.library.core.sila.types.SiLABoolean;

public class CloudierConnectionConfigurationService
extends ConnectionConfigurationServiceGrpc.ConnectionConfigurationServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(CloudierConnectionConfigurationService.class);
    private final AtomicBoolean isServerInitiated;
    private final Set<Runnable> connectionModeListeners = new HashSet<Runnable>();
    private final Set<Runnable> clientsListeners = new HashSet<Runnable>();
    private final Map<String, ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Parameters> configuredClients = new HashMap<String, ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Parameters>();
    private final ConnectionConfigurationSwitch listener;

    public CloudierConnectionConfigurationService(boolean cloudEnabledDefault, ConnectionConfigurationSwitch listener) {
        this.isServerInitiated = new AtomicBoolean(cloudEnabledDefault);
        this.listener = listener;
    }

    public CloudierConnectionConfigurationService(boolean cloudEnabledDefault, List<ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Parameters> defaultClients, ConnectionConfigurationSwitch listener) {
        defaultClients.forEach(c -> this.configuredClients.put(c.getClientName().getValue(), (ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Parameters)c));
        this.isServerInitiated = new AtomicBoolean(cloudEnabledDefault);
        this.listener = listener;
    }

    private void notifyConnectionModeListeners() {
        HashSet toRemove = new HashSet();
        this.connectionModeListeners.forEach(listener -> {
            try {
                listener.run();
            }
            catch (Exception e) {
                log.debug("Remove connection mode listener because of exception", (Throwable)e);
                toRemove.add(listener);
            }
        });
        this.connectionModeListeners.removeAll(toRemove);
        log.info("Connection mode listeners count {}", (Object)this.connectionModeListeners.size());
    }

    private void notifyClientsListeners() {
        HashSet toRemove = new HashSet();
        this.clientsListeners.forEach(listener -> {
            try {
                listener.run();
            }
            catch (Exception e) {
                log.debug("Remove configured clients listener because of exception", (Throwable)e);
                toRemove.add(listener);
            }
        });
        this.clientsListeners.removeAll(toRemove);
        log.info("Configured clients listeners count {}", (Object)this.clientsListeners.size());
        log.info("Configured clients client count {}", (Object)this.clientsListeners.size());
    }

    public void enableServerInitiatedConnectionMode(ConnectionConfigurationServiceOuterClass.EnableServerInitiatedConnectionMode_Parameters request, StreamObserver<ConnectionConfigurationServiceOuterClass.EnableServerInitiatedConnectionMode_Responses> responseObserver) {
        responseObserver.onNext((Object)ConnectionConfigurationServiceOuterClass.EnableServerInitiatedConnectionMode_Responses.newBuilder().build());
        responseObserver.onCompleted();
        this.isServerInitiated.set(true);
        this.listener.onSwitch(true);
    }

    public void disableServerInitiatedConnectionMode(ConnectionConfigurationServiceOuterClass.DisableServerInitiatedConnectionMode_Parameters request, StreamObserver<ConnectionConfigurationServiceOuterClass.DisableServerInitiatedConnectionMode_Responses> responseObserver) {
        responseObserver.onNext((Object)ConnectionConfigurationServiceOuterClass.DisableServerInitiatedConnectionMode_Responses.newBuilder().build());
        responseObserver.onCompleted();
        this.isServerInitiated.set(false);
        this.listener.onSwitch(false);
    }

    public void connectSiLAClient(ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Parameters request, StreamObserver<ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Responses> responseObserver) {
        String clientName = request.getClientName().getValue();
        this.configuredClients.put(clientName, request);
        this.notifyClientsListeners();
        responseObserver.onNext((Object)ConnectionConfigurationServiceOuterClass.ConnectSiLAClient_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void disconnectSiLAClient(ConnectionConfigurationServiceOuterClass.DisconnectSiLAClient_Parameters request, StreamObserver<ConnectionConfigurationServiceOuterClass.DisconnectSiLAClient_Responses> responseObserver) {
        String clientName = request.getClientName().getValue();
        boolean toRemove = request.getRemove().getValue();
        if (toRemove) {
            this.configuredClients.remove(clientName);
            this.notifyClientsListeners();
        }
        responseObserver.onNext((Object)ConnectionConfigurationServiceOuterClass.DisconnectSiLAClient_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void subscribeServerInitiatedConnectionModeStatus(ConnectionConfigurationServiceOuterClass.Subscribe_ServerInitiatedConnectionModeStatus_Parameters request, StreamObserver<ConnectionConfigurationServiceOuterClass.Subscribe_ServerInitiatedConnectionModeStatus_Responses> responseObserver) {
        Runnable callback = () -> {
            try {
                responseObserver.onNext((Object)ConnectionConfigurationServiceOuterClass.Subscribe_ServerInitiatedConnectionModeStatus_Responses.newBuilder().setServerInitiatedConnectionModeStatus(SiLABoolean.from((boolean)this.isServerInitiated.get())).build());
            }
            catch (Exception e) {
                responseObserver.onCompleted();
                throw e;
            }
        };
        callback.run();
        this.connectionModeListeners.add(callback);
    }

    public void subscribeConfiguredSiLAClients(ConnectionConfigurationServiceOuterClass.Subscribe_ConfiguredSiLAClients_Parameters request, StreamObserver<ConnectionConfigurationServiceOuterClass.Subscribe_ConfiguredSiLAClients_Responses> responseObserver) {
        Runnable callback = () -> {
            try {
                Set clients = this.configuredClients.values().stream().map(client -> ConnectionConfigurationServiceOuterClass.Subscribe_ConfiguredSiLAClients_Responses.ConfiguredSiLAClients_Struct.newBuilder().setClientName(client.getClientName()).setSiLAClientHost(client.getSiLAClientHost()).setSiLAClientPort(client.getSiLAClientPort()).build()).collect(Collectors.toSet());
                responseObserver.onNext((Object)ConnectionConfigurationServiceOuterClass.Subscribe_ConfiguredSiLAClients_Responses.newBuilder().addAllConfiguredSiLAClients(clients).build());
            }
            catch (Exception e) {
                responseObserver.onCompleted();
                throw e;
            }
        };
        callback.run();
        this.clientsListeners.add(callback);
    }

    @FunctionalInterface
    public static interface ConnectionConfigurationSwitch {
        public void onSwitch(boolean var1);
    }
}

