/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.communication.socket;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.communication.socket.CommunicationSocket;

public class SerialCommunication
extends CommunicationSocket {
    private static final Logger log = LoggerFactory.getLogger(SerialCommunication.class);
    public static final String DEFAULT_SERIAL_COM_NAME = "USB-to-Serial Port";
    private final String serialComName;
    private SerialPort serialPort;

    public SerialCommunication() {
        this.serialComName = DEFAULT_SERIAL_COM_NAME;
    }

    public SerialCommunication(@NonNull String serialComName) {
        if (serialComName == null) {
            throw new NullPointerException("serialComName is marked non-null but is null");
        }
        this.serialComName = serialComName;
    }

    @Override
    synchronized void openSocket() throws IOException {
        for (SerialPort port : SerialPort.getCommPorts()) {
            if (!port.getDescriptivePortName().contains(this.serialComName)) continue;
            log.info("Found serial adapter on " + port.getSystemPortName());
            this.serialPort = port;
            break;
        }
        if (this.serialPort == null) {
            throw new IOException("Can not find serial adapter!");
        }
        this.serialPort.openPort();
        if (!this.serialPort.isOpen()) {
            throw new IOException("Port " + this.serialPort.getDescriptivePortName() + " cannot be opened. Perhaps permissions (this user has no access to port)?");
        }
        this.serialPort.setComPortTimeouts(1, 5000, 0);
        this.serialPort.setComPortParameters(9600, 8, 1, 0);
        this.serialPort.setFlowControl(0);
    }

    @Override
    public synchronized void closeSocket() {
        if (this.serialPort != null) {
            this.serialPort.closePort();
            this.serialPort = null;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.serialPort.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.serialPort.getInputStream();
    }
}

