/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.communication.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.communication.socket.CommunicationSocket;

public class TcpCommunication
extends CommunicationSocket {
    private static final Logger log = LoggerFactory.getLogger(TcpCommunication.class);
    private final String ip;
    private final int port;
    private Socket socket;

    public TcpCommunication(@NonNull String ip, @NonNull int port) {
        if (ip == null) {
            throw new NullPointerException("ip is marked non-null but is null");
        }
        this.ip = ip;
        this.port = port;
    }

    @Override
    synchronized void openSocket() throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.ip, this.port);
        if (inetSocketAddress.isUnresolved()) {
            throw new IOException(String.format("Inet Socket Address %s:%d NOT resolvable", this.ip, this.port));
        }
        if (this.socket != null) {
            throw new IllegalStateException("Socket was not properly closed.");
        }
        this.socket = new Socket();
        this.socket.connect(inetSocketAddress);
        if (!this.socket.isConnected()) {
            throw new IOException("Connection didn't succeed");
        }
    }

    @Override
    synchronized void closeSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }
}

