/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.server_management;

import com.google.common.net.HostAndPort;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila_java.library.core.asynchronous.TaskScheduler;
import sila_java.library.manager.SiLAManager;
import sila_java.library.manager.models.Server;
import sila_java.library.manager.server_management.DiscoveryListener;
import sila_java.library.manager.server_management.ServerLoading;

public class ServerHeartbeat {
    private static final Logger log = LoggerFactory.getLogger(ServerHeartbeat.class);
    private static final int CONNECT_TIMEOUT = 2000;
    private final SiLAManager siLAManager;
    private final TaskScheduler pingScheduler;
    private final DiscoveryListener discoveryListener;

    public ServerHeartbeat(@NonNull SiLAManager siLAManager, @NonNull DiscoveryListener discoveryListener, int period) {
        if (siLAManager == null) {
            throw new NullPointerException("siLAManager");
        }
        if (discoveryListener == null) {
            throw new NullPointerException("discoveryListener");
        }
        this.siLAManager = siLAManager;
        this.discoveryListener = discoveryListener;
        this.pingScheduler = new TaskScheduler(this::checkAll, (long)period, "Ping Scheduler");
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public void start() {
        this.pingScheduler.start();
    }

    public void stop() {
        this.pingScheduler.stop();
    }

    private void checkAll() {
        HashSet onlineSockets = new HashSet();
        this.siLAManager.getSiLAServers().forEach((key, server) -> {
            if (!server.getStatus().equals((Object)Server.Status.INVALID)) {
                Server.Status status = Server.Status.OFFLINE;
                HostAndPort hostAndPort = HostAndPort.fromParts((String)server.getHost(), (int)server.getPort());
                boolean socketUp = this.checkConnection(server.getHost(), server.getPort());
                if (!onlineSockets.contains(hostAndPort) && socketUp) {
                    try {
                        ManagedChannel managedChannel = this.siLAManager.getSilaConnections().get(key).getManagedChannel();
                        UUID uuid = ServerLoading.getServerId(SiLAServiceGrpc.newBlockingStub((Channel)managedChannel));
                        if (server.getConfiguration().getUuid().equals(uuid)) {
                            status = Server.Status.ONLINE;
                            onlineSockets.add(hostAndPort);
                        }
                    }
                    catch (Exception e) {
                        log.debug("Failing UUID Retrieval {}", (Object)e.getMessage());
                    }
                }
                this.siLAManager.setServerStatus(server.getConfiguration().getUuid(), status);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkConnection(@NonNull String host, int port) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        InetSocketAddress endPoint = new InetSocketAddress(host, port);
        if (endPoint.isUnresolved()) {
            log.error("Failure " + endPoint);
            return false;
        }
        try (Socket socket = new Socket();){
            socket.connect(endPoint, 2000);
            log.debug("Success reaching socket {}", (Object)endPoint);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.debug("Failure reaching socket {} message: {} - {}", new Object[]{endPoint, e.getClass().getSimpleName(), e.getMessage()});
            return false;
        }
    }
}

