/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.server_management;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import java.io.Reader;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.io.input.CharSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.core.mapping.FeatureGenerator;
import sila_java.library.core.models.Feature;
import sila_java.library.manager.models.Server;
import sila_java.library.server_base.config.ServerConfiguration;
import sila_java.library.server_base.identification.ServerInformation;

public abstract class ServerLoading {
    private static final Logger log = LoggerFactory.getLogger(ServerLoading.class);
    private static final long MAX_SERVICE_TIMEOUT = 10L;

    public static void loadServer(@NonNull Server server, @NonNull ManagedChannel managedChannel) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        if (managedChannel == null) {
            throw new NullPointerException("managedChannel");
        }
        SiLAServiceGrpc.SiLAServiceBlockingStub siLAService = SiLAServiceGrpc.newBlockingStub((Channel)managedChannel);
        try {
            UUID serverUUID = ServerLoading.getServerId(siLAService);
            log.info("Got serverUUID: {}", (Object)serverUUID);
            String serverName = ServerLoading.getServerName(siLAService);
            String serverType = ServerLoading.getServerType(siLAService);
            String serverDescription = ServerLoading.getServerDescription(siLAService, serverName);
            String serverVendorURL = ServerLoading.getServerVendor(siLAService);
            String serverVersion = ServerLoading.getServerVersion(siLAService);
            server.setConfiguration(new ServerConfiguration(serverName, serverUUID));
            server.setInformation(new ServerInformation(serverType, serverDescription, serverVendorURL, serverVersion));
            log.info("{} Saved Server Information", (Object)serverName);
            SiLAServiceOuterClass.Get_ImplementedFeatures_Responses featureList = ServerLoading.getFeatureList(siLAService, serverName);
            ServerLoading.loadFeatures(siLAService, server, featureList);
            server.setStatus(Server.Status.ONLINE);
        }
        catch (StatusRuntimeException e) {
            String errorMessage = String.format("SiLA Service doesn't return because %s. Timeout was set to %d s", e.getMessage(), 10L);
            log.warn(errorMessage);
            server.getErrorMessages().add(errorMessage);
        }
    }

    public static UUID getServerId(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        String serverUUIDStr = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getServerUUID(SiLAServiceOuterClass.Get_ServerUUID_Parameters.newBuilder().build()).getServerUUID().getValue();
        return UUID.fromString(serverUUIDStr);
    }

    private static SiLAServiceOuterClass.Get_ImplementedFeatures_Responses getFeatureList(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService, @NonNull String serverName) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        long start = System.currentTimeMillis();
        SiLAServiceOuterClass.Get_ImplementedFeatures_Responses featureList = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getImplementedFeatures(SiLAServiceOuterClass.Get_ImplementedFeatures_Parameters.newBuilder().build());
        log.info("{} Got List of Features in {} ms", (Object)serverName, (Object)(System.currentTimeMillis() - start));
        return featureList;
    }

    private static String getServerVersion(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        String serverVersion = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getServerVersion(SiLAServiceOuterClass.Get_ServerVersion_Parameters.newBuilder().build()).getServerVersion().getValue();
        log.info("Got serverVersion: {}", (Object)serverVersion);
        return serverVersion;
    }

    private static String getServerVendor(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        String serverVendorURL = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getServerVendorURL(SiLAServiceOuterClass.Get_ServerVendorURL_Parameters.newBuilder().build()).getServerVendorURL().getURL().getValue();
        log.info("Got serverVendorURL: {}", (Object)serverVendorURL);
        return serverVendorURL;
    }

    private static String getServerDescription(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService, @NonNull String serverName) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        String serverDescription = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getServerDescription(SiLAServiceOuterClass.Get_ServerDescription_Parameters.newBuilder().build()).getServerDescription().getValue();
        log.info("{} Got serverDescription: {}", (Object)serverName, (Object)serverDescription);
        return serverDescription;
    }

    private static String getServerType(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        String serverType = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getServerType(SiLAServiceOuterClass.Get_ServerType_Parameters.newBuilder().build()).getServerType().getValue();
        log.info("Got serverType: {}", (Object)serverType);
        return serverType;
    }

    private static String getServerName(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        String serverName = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getServerName(SiLAServiceOuterClass.Get_ServerName_Parameters.newBuilder().build()).getServerName().getValue();
        log.info("Got serverName: {}", (Object)serverName);
        return serverName;
    }

    private static void loadFeatures(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService, @NonNull Server server, @NonNull SiLAServiceOuterClass.Get_ImplementedFeatures_Responses featureList) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService");
        }
        if (server == null) {
            throw new NullPointerException("server");
        }
        if (featureList == null) {
            throw new NullPointerException("featureList");
        }
        featureList.getImplementedFeaturesList().forEach(featureIdentifier -> {
            SiLAServiceOuterClass.GetFeatureDefinition_Parameters par = SiLAServiceOuterClass.GetFeatureDefinition_Parameters.newBuilder().setQualifiedFeatureIdentifier(featureIdentifier).build();
            SiLAServiceOuterClass.GetFeatureDefinition_Responses featureDefinition = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(10L, TimeUnit.SECONDS)).getFeatureDefinition(par);
            String rawFeatureDefinition = featureDefinition.getFeatureDefinition().getFeatureDefinition().getValue();
            try {
                Feature featurePojo = FeatureGenerator.generateFeature((Reader)new CharSequenceReader((CharSequence)rawFeatureDefinition));
                log.info("Feature {}=", featureIdentifier);
                log.info("{} ", (Object)featurePojo);
                server.getFeatures().add(featurePojo);
            }
            catch (Exception e) {
                String errorMessage = String.format("Parsing of Feature %s failed. Reason=%s", featureIdentifier, e.getMessage());
                log.warn(errorMessage);
                server.getErrorMessages().add(errorMessage);
            }
        });
    }

    private ServerLoading() {
    }
}

