/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.server_management;

import com.google.protobuf.Descriptors;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.security.KeyException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SiLAConnection
implements Closeable {
    private final Map<String, Descriptors.ServiceDescriptor> featureMap = new HashMap<String, Descriptors.ServiceDescriptor>();
    private final ManagedChannel managedChannel;

    public SiLAConnection(ManagedChannel managedChannel) {
        this.managedChannel = managedChannel;
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public Descriptors.ServiceDescriptor getFeatureService(String featureId) throws KeyException {
        if (!this.featureMap.containsKey(featureId)) {
            throw new KeyException("Can't find expose Feature" + featureId);
        }
        return this.featureMap.get(featureId);
    }

    public void addFeatureService(String featureId, Descriptors.ServiceDescriptor serviceDescriptor) {
        this.featureMap.put(featureId, serviceDescriptor);
    }

    @Override
    public void close() {
        if (this.managedChannel != null) {
            try {
                this.managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public ManagedChannel getManagedChannel() {
        return this.managedChannel;
    }
}

