package sila_java.library.manager.models;

import lombok.Data;
import sila_java.library.core.models.Feature;
import sila_java.library.server_base.config.ServerConfiguration;
import sila_java.library.server_base.identification.ServerInformation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

/**
 * Server Model for SiLA Servers
 */
@Data
public class Server {
    public enum Status {
        ONLINE, OFFLINE, INVALID
    }
    private Date joined;

    // If found with discovery, a discovery id is set.
    // @implNote Should be null for manual
    private final UUID discoveryId;

    // Status of the SiLA Server, Invalid means can't be parsed completely
    private Status status;

    // Host & Port of the SiLA Server
    private String host;
    private Integer port;

    // SiLA Service parsed information
    private ServerConfiguration configuration;
    private ServerInformation information;
    private final List<Feature> features = new ArrayList<>();

    // Error Messages for Invalid SiLA Servers
    private final List<String> errorMessages = new ArrayList<>();

    public Server(UUID discoveryId) {
        this.discoveryId = discoveryId;
    }
}
