package sila_java.library.manager.server_management;

import io.netty.util.internal.ConcurrentSet;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import sila_java.library.manager.SiLAManager;
import sila_java.library.manager.models.Server;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Listener adding SiLA Servers to Cache
 */
@Slf4j
public class DiscoveryListener implements sila_java.library.core.discovery.ServerListener {
    private final SiLAManager siLAManager;
    private final Set<UUID> uuidCache = new ConcurrentSet<>();

    public DiscoveryListener(@NonNull final SiLAManager siLAManager) {
        this.siLAManager = siLAManager;
    }

    public void removeFromCache(UUID uuid) {
        uuidCache.remove(uuid);
    }

    @Override
    public synchronized void serverAdded(@NonNull final UUID instanceID, @NonNull final String host, final int port) {
        // Only add new UUIDs
        if (!uuidCache.contains(instanceID)) {
            log.info("[serverAdded] Found Service Instance {} on {}:{}", instanceID, host, port);
            this.siLAManager.addServer(host, port, instanceID);
            uuidCache.add(instanceID);
        }
    }
}
