package sila_java.library.manager.server_management;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import sila_java.library.manager.models.Server;

/**
 * Utilities for SiLA Server Handling
 */
@Slf4j
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public abstract class ServerUtilities {
    /**
     * Build a new gRPC Channel instance related to a SiLA Server
     *
     * @param server SiLA Server related to the channel
     * @implNote In the future, this can deal with the encryption from the client side.
     * @return A new Channel connected to Server
     */
    public static ManagedChannel buildNewChannel(@NonNull final Server server) {
        return ManagedChannelBuilder.forAddress(server.getHost(), server.getPort()).usePlaintext(true).build();
    }
}
