/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.security.KeyException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.mapping.GrpcMapper;
import sila_java.library.manager.executor.StaticStreamObserver;
import sila_java.library.manager.grpc.DynamicMessageMarshaller;
import sila_java.library.manager.models.SiLACall;
import sila_java.library.manager.server_management.SiLAConnection;

public class ServerCallExecutor {
    private static final Logger log = LoggerFactory.getLogger(ServerCallExecutor.class);
    private static final int MAX_WAIT_TIME = 1;
    private static final TimeUnit MAX_WAIT_TIME_UNIT = TimeUnit.MINUTES;
    private final SiLAConnection connection;
    private final SiLACall baseCall;
    private final Descriptors.ServiceDescriptor feature;

    public ServerCallExecutor(@NonNull SiLAConnection connection, @NonNull SiLACall baseCall) throws KeyException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (baseCall == null) {
            throw new NullPointerException("baseCall");
        }
        this.connection = connection;
        this.baseCall = baseCall;
        this.feature = connection.getFeatureService(baseCall.getFeatureId());
    }

    public String execute() {
        String result = "";
        switch (this.baseCall.getType()) {
            case UNOBSERVABLE_COMMAND: {
                result = this.executeUnobservableCommand();
                break;
            }
            case OBSERVABLE_COMMAND: {
                result = this.executeObservableCommand();
                break;
            }
            case UNOBSERVABLE_PROPERTY: {
                result = this.getUnobservableProperty();
                break;
            }
            case OBSERVABLE_PROPERTY: {
                result = this.getObservableProperty();
            }
        }
        return result;
    }

    private String executeUnobservableCommand() {
        return this.executeCall(this.baseCall.getCallId(), this.baseCall.getParameters());
    }

    private String executeObservableCommand() {
        try {
            SiLAFramework.CommandConfirmation.Builder command = SiLAFramework.CommandConfirmation.newBuilder();
            JsonFormat.parser().merge(this.executeCall(this.baseCall.getCallId(), this.baseCall.getParameters()), (Message.Builder)command);
            String commandId = JsonFormat.printer().print((MessageOrBuilder)command.getCommandId());
            AtomicInteger commandStatus = new AtomicInteger(0);
            CompletableFuture<List<String>> future = this.executeStream(GrpcMapper.getStateCommand((String)this.baseCall.getCallId()), commandId, message -> {
                try {
                    SiLAFramework.ExecutionInfo.Builder stateBuilder = SiLAFramework.ExecutionInfo.newBuilder();
                    JsonFormat.parser().merge(message, (Message.Builder)stateBuilder);
                    log.info("Received status for call " + this.baseCall.toString());
                    log.info(stateBuilder.toString());
                    commandStatus.set(stateBuilder.getCommandStatus().getNumber());
                    return commandStatus.get() == 1 || commandStatus.get() == 0;
                }
                catch (InvalidProtocolBufferException e) {
                    log.warn("Received a malformed message: ", (Throwable)e);
                    return false;
                }
            });
            try {
                future.get();
            }
            catch (InterruptedException | CompletionException | ExecutionException e) {
                if (e.getCause() != null && e.getCause() instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e.getCause();
                }
                throw new Exception(e);
            }
            if (commandStatus.get() == 2) {
                return this.executeCall(GrpcMapper.getResult((String)this.baseCall.getCallId()), commandId);
            }
            throw new Exception("Command state ended with an invalid state: " + commandStatus.get());
        }
        catch (InvalidProtocolBufferException e) {
            throw new Exception("Received a malformed message", e.getCause());
        }
    }

    private String getUnobservableProperty() {
        return this.executeCall(GrpcMapper.getUnobservableProperty((String)this.baseCall.getCallId()), this.baseCall.getParameters());
    }

    private String getObservableProperty() {
        CompletableFuture<List<String>> future = this.executeStream(GrpcMapper.getObservableProperty((String)this.baseCall.getCallId()), this.baseCall.getParameters(), message -> false);
        try {
            List<String> results = future.get();
            if (results.isEmpty()) {
                throw new RuntimeException("No result");
            }
            return results.get(results.size() - 1);
        }
        catch (InterruptedException | CompletionException | ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof StatusRuntimeException) {
                throw (StatusRuntimeException)e.getCause();
            }
            throw new Exception(e);
        }
    }

    private String executeCall(@NonNull String callId, @NonNull String params) {
        String results;
        if (callId == null) {
            throw new NullPointerException("callId");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        Descriptors.MethodDescriptor method = this.feature.findMethodByName(callId);
        if (method == null) {
            throw new Exception("Server " + this.baseCall.getServerId() + " doesn't expose call to " + callId);
        }
        DynamicMessage request = ServerCallExecutor.getRequestMessage(method, params);
        MethodDescriptor<Object, Object> methodDescriptor = ServerCallExecutor.getMethodDescriptor(method);
        DynamicMessage unaryCall = (DynamicMessage)ClientCalls.blockingUnaryCall((ClientCall)this.connection.getManagedChannel().newCall(methodDescriptor, CallOptions.DEFAULT.withDeadlineAfter(1L, MAX_WAIT_TIME_UNIT)), (Object)request);
        try {
            results = JsonFormat.printer().print((MessageOrBuilder)unaryCall);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return results;
    }

    private CompletableFuture<List<String>> executeStream(@NonNull String callId, @NonNull String params, @Nullable StaticStreamObserver.StreamCallback callback) {
        if (callId == null) {
            throw new NullPointerException("callId");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        Descriptors.MethodDescriptor method = this.feature.findMethodByName(callId);
        if (method == null) {
            throw new Exception("Server " + this.baseCall.getServerId() + " doesn't expose call to " + callId);
        }
        DynamicMessage request = ServerCallExecutor.getRequestMessage(method, params);
        MethodDescriptor<Object, Object> methodDescriptor = ServerCallExecutor.getMethodDescriptor(method);
        ClientCall clientCall = this.connection.getManagedChannel().newCall(methodDescriptor, CallOptions.DEFAULT);
        StaticStreamObserver propertyObserver = new StaticStreamObserver((ClientCall<Object, Object>)clientCall, callback);
        ClientCalls.asyncServerStreamingCall((ClientCall)clientCall, (Object)request, (StreamObserver)propertyObserver);
        return propertyObserver.getFuture();
    }

    private static MethodDescriptor<Object, Object> getMethodDescriptor(@NonNull Descriptors.MethodDescriptor method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(ServerCallExecutor.getFullMethodName(method)).setRequestMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(method.getInputType())).setResponseMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(method.getOutputType())).build();
    }

    private static String getFullMethodName(@NonNull Descriptors.MethodDescriptor method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        return MethodDescriptor.generateFullMethodName((String)method.getService().getFullName(), (String)method.getName());
    }

    private static DynamicMessage getRequestMessage(@NonNull Descriptors.MethodDescriptor method, @NonNull String params) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        DynamicMessage.Builder parBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)method.getInputType());
        try {
            JsonFormat.parser().merge(params, (Message.Builder)parBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return parBuilder.build();
    }

    public static class Exception
    extends RuntimeException {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }

        public Exception(Throwable cause) {
            super(cause);
        }
    }
}

