/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ClientCall;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class StaticStreamObserver
implements StreamObserver<Object> {
    private final ConcurrentLinkedDeque<String> resultsList = new ConcurrentLinkedDeque();
    private final CompletableFuture<List<String>> future = new CompletableFuture();
    private final ClientCall<Object, Object> clientCall;
    private final StreamCallback callback;

    public StaticStreamObserver(@NonNull ClientCall<Object, Object> clientCall, @Nullable StreamCallback callback) {
        if (clientCall == null) {
            throw new NullPointerException("clientCall");
        }
        this.clientCall = clientCall;
        this.callback = callback;
    }

    public CompletableFuture<List<String>> getFuture() {
        return this.future;
    }

    public void onNext(Object message) {
        try {
            String json = JsonFormat.printer().print((MessageOrBuilder)((DynamicMessage)message));
            this.resultsList.add(json);
            if (this.callback != null && !this.callback.onNext(json)) {
                this.clientCall.cancel(null, (Throwable)new StreamCancellationException());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.onError(new IllegalArgumentException(e.getMessage()));
        }
    }

    public void onError(Throwable throwable) {
        if (throwable.getCause() instanceof StreamCancellationException) {
            this.future.complete(new ArrayList<String>(this.resultsList));
        } else {
            this.future.completeExceptionally(throwable);
        }
    }

    public void onCompleted() {
        this.future.complete(new ArrayList<String>(this.resultsList));
    }

    public static interface StreamCallback {
        public boolean onNext(String var1);
    }

    private static final class StreamCancellationException
    extends RuntimeException {
        private StreamCancellationException() {
        }
    }
}

