/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.models;

import java.util.UUID;
import lombok.NonNull;

public final class SiLACall {
    @NonNull
    private final UUID serverId;
    @NonNull
    private final String featureId;
    @NonNull
    private final String callId;
    @NonNull
    private final Type type;
    @NonNull
    private final String parameters;

    public SiLACall(@NonNull UUID serverId, @NonNull String featureId, @NonNull String callId, @NonNull Type type, @NonNull String parameters) {
        if (serverId == null) {
            throw new NullPointerException("serverId");
        }
        if (featureId == null) {
            throw new NullPointerException("featureId");
        }
        if (callId == null) {
            throw new NullPointerException("callId");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        this.serverId = serverId;
        this.featureId = featureId;
        this.callId = callId;
        this.type = type;
        this.parameters = parameters;
    }

    public SiLACall(@NonNull UUID serverId, @NonNull String featureId, @NonNull String callId, @NonNull Type type) {
        this(serverId, featureId, callId, type, "{}");
        if (serverId == null) {
            throw new NullPointerException("serverId");
        }
        if (featureId == null) {
            throw new NullPointerException("featureId");
        }
        if (callId == null) {
            throw new NullPointerException("callId");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
    }

    @NonNull
    public UUID getServerId() {
        return this.serverId;
    }

    @NonNull
    public String getFeatureId() {
        return this.featureId;
    }

    @NonNull
    public String getCallId() {
        return this.callId;
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    @NonNull
    public String getParameters() {
        return this.parameters;
    }

    public static enum Type {
        UNOBSERVABLE_COMMAND,
        OBSERVABLE_COMMAND,
        UNOBSERVABLE_PROPERTY,
        OBSERVABLE_PROPERTY;

    }
}

