/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.server_management;

import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.discovery.ServerListener;
import sila_java.library.manager.SiLAManager;

public class DiscoveryListener
implements ServerListener {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryListener.class);
    private final SiLAManager siLAManager;
    private final Set<UUID> uuidCache = new ConcurrentSet();

    public DiscoveryListener(@NonNull SiLAManager siLAManager) {
        if (siLAManager == null) {
            throw new NullPointerException("siLAManager");
        }
        this.siLAManager = siLAManager;
    }

    public void removeFromCache(UUID uuid) {
        this.uuidCache.remove(uuid);
    }

    public synchronized void serverAdded(@NonNull UUID instanceID, @NonNull String host, int port) {
        if (instanceID == null) {
            throw new NullPointerException("instanceID");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        if (!this.uuidCache.contains(instanceID)) {
            log.info("[serverAdded] Found Service Instance {} on {}:{}", new Object[]{instanceID, host, port});
            this.siLAManager.addServer(host, port, instanceID);
            this.uuidCache.add(instanceID);
        }
    }
}

