/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.BinaryDownloadGrpc;
import sila2.org.silastandard.BinaryUploadGrpc;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLACloudConnector;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.cloudier.client.CloudierClient;
import sila_java.library.cloudier.client.CloudierClientEndpoint;
import sila_java.library.cloudier.client.CloudierClientObserver;
import sila_java.library.core.models.Feature;
import sila_java.library.core.sila.errors.ExceptionGeneration;
import sila_java.library.core.sila.errors.SiLAErrorException;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.mapping.grpc.GrpcNameMapper;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.executor.BinaryDownloader;
import sila_java.library.manager.executor.BinaryDownloaderStream;
import sila_java.library.manager.executor.BinaryUploader;
import sila_java.library.manager.executor.BinaryUploaderStream;
import sila_java.library.manager.executor.CallListener;
import sila_java.library.manager.executor.ExecutableServerCall;
import sila_java.library.manager.executor.stream.StaticStreamObserver;
import sila_java.library.manager.executor.stream.StreamCallback;
import sila_java.library.manager.grpc.Constants;
import sila_java.library.manager.grpc.DynamicMessageMarshaller;
import sila_java.library.manager.grpc.FullyQualifiedMetadataContextKey;
import sila_java.library.manager.models.CallCompleted;
import sila_java.library.manager.models.CallErrored;
import sila_java.library.manager.models.CallStarted;
import sila_java.library.manager.models.Server;
import sila_java.library.manager.models.SiLACall;

public class ServerCallExecutor
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ServerCallExecutor.class);
    private final ExecutableServerCall call;
    private final CallListener callListener;
    private final List<CompletableFuture<List<String>>> internalFutures = new CopyOnWriteArrayList<CompletableFuture<List<String>>>();
    private final List<ClientCall<Object, Object>> internalCalls = new CopyOnWriteArrayList<ClientCall<Object, Object>>();

    public ServerCallExecutor(@NonNull ExecutableServerCall call) {
        this(call, new CallListener(){});
        if (call == null) {
            throw new NullPointerException("call is marked non-null but is null");
        }
    }

    @Override
    public void close() {
        this.internalFutures.forEach(f -> {
            if (!f.isDone()) {
                f.cancel(true);
            }
        });
        this.internalCalls.forEach(c -> c.cancel("Interrupted", null));
    }

    String executeCloudier() {
        String callIdPrefix;
        String fullyQualifiedCallIdentifier;
        CloudierClient cloudierClient = ServerManager.getInstance().getCloudierClient();
        CloudierClientObserver cloudierClientObserver = cloudierClient != null ? (CloudierClientObserver)cloudierClient.getEndpointService().getResponseObservers().get(this.call.getBaseCall().getServerId().toString()) : null;
        Server server = ServerManager.getInstance().getServers().get(this.call.getBaseCall().getServerId());
        Feature feature = server.getFeatures().stream().filter(f -> f.getIdentifier().equals(this.call.getBaseCall().getFullyQualifiedFeatureId())).findAny().orElse(null);
        String fullyQualifiedFeature = feature == null ? "" : feature.getOriginator() + "/" + feature.getCategory() + "/" + feature.getIdentifier() + "/v" + (int)Float.parseFloat(feature.getFeatureVersion());
        switch (this.call.getBaseCall().getType()) {
            case OBSERVABLE_PROPERTY_READ: 
            case OBSERVABLE_PROPERTY: {
                fullyQualifiedCallIdentifier = fullyQualifiedFeature + "/Property/" + this.call.getBaseCall().getCallId();
                callIdPrefix = "Subscribe_";
                break;
            }
            case UNOBSERVABLE_PROPERTY: {
                fullyQualifiedCallIdentifier = fullyQualifiedFeature + "/Property/" + this.call.getBaseCall().getCallId();
                callIdPrefix = "Get_";
                break;
            }
            case OBSERVABLE_COMMAND: {
                fullyQualifiedCallIdentifier = fullyQualifiedFeature + "/Command/" + this.call.getBaseCall().getCallId();
                callIdPrefix = "";
                break;
            }
            case UNOBSERVABLE_COMMAND: {
                fullyQualifiedCallIdentifier = fullyQualifiedFeature + "/Command/" + this.call.getBaseCall().getCallId();
                callIdPrefix = "";
                break;
            }
            case GET_FCP_AFFECTED_BY_METADATA: {
                fullyQualifiedCallIdentifier = fullyQualifiedFeature + "/Metadata/" + this.call.getBaseCall().getCallId();
                callIdPrefix = GrpcNameMapper.getMetadataRPC((String)"");
                break;
            }
            default: {
                fullyQualifiedCallIdentifier = "";
                callIdPrefix = "";
            }
        }
        if (cloudierClientObserver == null) {
            throw new RuntimeException("Server " + this.call.getBaseCall().getServerId() + " is not connected for server initiated connection");
        }
        if (this.call.getBaseCall().getType() != SiLACall.Type.UPLOAD_BINARY && this.call.getBaseCall().getType() != SiLACall.Type.DOWNLOAD_BINARY && (fullyQualifiedFeature.isEmpty() || fullyQualifiedCallIdentifier.isEmpty())) {
            throw new RuntimeException("Invalid fully qualified call identifier");
        }
        log.debug("[Cloudier] FQ call id " + fullyQualifiedCallIdentifier);
        String callId = callIdPrefix + this.call.getBaseCall().getCallId();
        switch (this.call.getBaseCall().getType()) {
            case UNOBSERVABLE_COMMAND: {
                return this.executeCallWithProgression(() -> {
                    Descriptors.MethodDescriptor method = this.getMethodDescriptor(callId);
                    DynamicMessage requestParameter = ServerCallExecutor.getRequestMessage(method, this.call.getBaseCall().getParameters());
                    SiLACloudConnector.CommandParameter.Builder commandParameterBuilder = SiLACloudConnector.CommandParameter.newBuilder().setParameters(requestParameter.toByteString());
                    commandParameterBuilder.addAllMetadata(ServerCallExecutor.getCloudMetadataSet(this.getMetadataMap()));
                    CompletableFuture byteStringCompletableFuture = cloudierClientObserver.runUnobservableCommand(SiLACloudConnector.UnobservableCommandExecution.newBuilder().setCommandParameter(commandParameterBuilder.build()).setFullyQualifiedCommandId(fullyQualifiedCallIdentifier).build());
                    try {
                        ByteString bytes = (ByteString)this.callFuture(byteStringCompletableFuture, ignored -> {});
                        DynamicMessage requestResponse = ServerCallExecutor.getRequestResponse(method, bytes);
                        return ProtoMapper.serializeToJson((MessageOrBuilder)requestResponse);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            case OBSERVABLE_COMMAND: {
                return this.executeCallWithProgression(() -> {
                    Descriptors.MethodDescriptor method = this.getMethodDescriptor(callId);
                    DynamicMessage requestParameter = ServerCallExecutor.getRequestMessage(method, this.call.getBaseCall().getParameters());
                    SiLACloudConnector.CommandParameter.Builder commandParameterBuilder = SiLACloudConnector.CommandParameter.newBuilder().setParameters(requestParameter.toByteString());
                    commandParameterBuilder.addAllMetadata(ServerCallExecutor.getCloudMetadataSet(this.getMetadataMap()));
                    Optional<Object> intermediateResponse = Optional.empty();
                    try {
                        intermediateResponse = Optional.of(this.getMethodDescriptor(this.call.getBaseCall().getCallId() + "_Intermediate"));
                    }
                    catch (RuntimeException e) {
                        log.info("Call {} does not have intermediate response", (Object)this.call.getBaseCall().getCallId());
                    }
                    final Optional finalIntermediateResponse = intermediateResponse;
                    CompletableFuture byteStringCompletableFuture = cloudierClientObserver.runObservableCommand(commandParameterBuilder.build(), fullyQualifiedCallIdentifier, intermediateResponse.isPresent(), new CloudierClientEndpoint.CallListener(){

                        public void onCommandInit(SiLACloudConnector.ObservableCommandConfirmation observableCommandConfirmation) {
                            ServerCallExecutor.this.callListener.onObservableCommandInit(ServerCallExecutor.this.call.getBaseCall(), observableCommandConfirmation.getCommandConfirmation());
                        }

                        public void onCommandExecutionInfo(SiLACloudConnector.ObservableCommandExecutionInfo observableCommandExecutionInfo) {
                            ServerCallExecutor.this.callListener.onObservableCommandExecutionInfo(ServerCallExecutor.this.call.getBaseCall(), observableCommandExecutionInfo.getExecutionInfo());
                        }

                        public void onIntermediateResponse(SiLACloudConnector.ObservableCommandIntermediateResponse observableCommandExecutionInfo) {
                            finalIntermediateResponse.ifPresent(intermediateResponse -> {
                                DynamicMessage requestResponse = ServerCallExecutor.getRequestResponse(intermediateResponse, observableCommandExecutionInfo.getResponse());
                                ServerCallExecutor.this.callListener.onObservableIntermediateResponse(ServerCallExecutor.this.call.getBaseCall(), requestResponse);
                            });
                        }

                        public void onError(SiLAFramework.SiLAError siLAError) {
                        }
                    });
                    try {
                        ByteString bytes = (ByteString)this.callFuture(byteStringCompletableFuture, ignored -> {});
                        Descriptors.MethodDescriptor methodResult = this.getMethodDescriptor(callId + "_Result");
                        DynamicMessage requestResponse = ServerCallExecutor.getRequestResponse(methodResult, bytes);
                        return ProtoMapper.serializeToJson((MessageOrBuilder)requestResponse);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            case UNOBSERVABLE_PROPERTY: {
                return this.executeCallWithProgression(() -> {
                    Descriptors.MethodDescriptor method = this.getMethodDescriptor(callId);
                    SiLACloudConnector.UnobservablePropertyRead.Builder propertyBuilder = SiLACloudConnector.UnobservablePropertyRead.newBuilder().setFullyQualifiedPropertyId(fullyQualifiedCallIdentifier);
                    propertyBuilder.addAllMetadata(ServerCallExecutor.getCloudMetadataSet(this.getMetadataMap()));
                    CompletableFuture byteStringCompletableFuture = cloudierClientObserver.readUnobservableProperty(propertyBuilder.build());
                    try {
                        ByteString bytes = (ByteString)this.callFuture(byteStringCompletableFuture, ignored -> {});
                        DynamicMessage requestResponse = ServerCallExecutor.getRequestResponse(method, bytes);
                        return ProtoMapper.serializeToJson((MessageOrBuilder)requestResponse);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            case OBSERVABLE_PROPERTY_READ: 
            case OBSERVABLE_PROPERTY: {
                return this.executeCallWithProgression(() -> {
                    Descriptors.MethodDescriptor method = this.getMethodDescriptor(callId);
                    SiLACloudConnector.ObservablePropertySubscription.Builder propertySubscription = SiLACloudConnector.ObservablePropertySubscription.newBuilder().setFullyQualifiedPropertyId(fullyQualifiedCallIdentifier);
                    propertySubscription.addAllMetadata(ServerCallExecutor.getCloudMetadataSet(this.getMetadataMap()));
                    CompletableFuture byteStringCompletableFuture = cloudierClientObserver.readObservableProperty(propertySubscription.build(), response -> {
                        DynamicMessage requestResponse = ServerCallExecutor.getRequestResponse(method, response);
                        try {
                            this.callListener.onObservablePropertyUpdate(this.call.getBaseCall(), ProtoMapper.serializeToJson((MessageOrBuilder)requestResponse));
                        }
                        catch (InvalidProtocolBufferException e) {
                            e.printStackTrace();
                        }
                        return this.call.getBaseCall().getType().equals((Object)SiLACall.Type.OBSERVABLE_PROPERTY);
                    });
                    try {
                        ByteString bytes = (ByteString)this.callFuture(byteStringCompletableFuture, ignored -> {});
                        DynamicMessage requestResponse = ServerCallExecutor.getRequestResponse(method, bytes);
                        return ProtoMapper.serializeToJson((MessageOrBuilder)requestResponse);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            case GET_FCP_AFFECTED_BY_METADATA: {
                return this.executeCallWithProgression(() -> {
                    Descriptors.MethodDescriptor method = this.getMethodDescriptor(callId);
                    CompletableFuture byteStringCompletableFuture = cloudierClientObserver.getFCPAffectedByMetadata(fullyQualifiedCallIdentifier);
                    try {
                        SiLACloudConnector.GetFCPAffectedByMetadataResponse getFCPAffectedByMetadataResponse = (SiLACloudConnector.GetFCPAffectedByMetadataResponse)this.callFuture(byteStringCompletableFuture, ignored -> {});
                        List metadataList = getFCPAffectedByMetadataResponse.getAffectedCallsList().stream().map(SiLAString::from).collect(Collectors.toList());
                        Descriptors.Descriptor outputType = method.getOutputType();
                        if (outputType == null) {
                            throw new RuntimeException("Service proto does not have get FCP Affected by metadata method");
                        }
                        Descriptors.FieldDescriptor affectedCallsField = outputType.findFieldByName("AffectedCalls");
                        if (affectedCallsField == null) {
                            throw new RuntimeException("FCP Affected by metadata method output type is invalid");
                        }
                        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)outputType);
                        builder.setField(affectedCallsField, metadataList);
                        return ProtoMapper.serializeToJson((MessageOrBuilder)builder.build());
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            case UPLOAD_BINARY: {
                return this.executeCallWithProgression(() -> {
                    BinaryUploader binaryUploader = this.call.getBinaryUploader().orElseThrow(() -> new RuntimeException("Binary uploader needs to be supplied to upload a large binary"));
                    try {
                        SiLABinaryTransfer.CreateBinaryResponse createBinaryResponse = (SiLABinaryTransfer.CreateBinaryResponse)cloudierClientObserver.createBinaryUploadRequest(binaryUploader.getRequest(), ServerCallExecutor.getCloudMetadataSet(this.getMetadataMap())).get();
                        for (int i = 0; i < binaryUploader.getChunkCount(); ++i) {
                            CompletableFuture uploadBinaryChunkResponse = cloudierClientObserver.uploadBinaryChunkRequest(binaryUploader.getNextChunkUploadRequest(createBinaryResponse.getBinaryTransferUUID()));
                            uploadBinaryChunkResponse.get();
                        }
                        return ProtoMapper.serializeToJson((MessageOrBuilder)createBinaryResponse);
                    }
                    catch (IOException | InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            case DOWNLOAD_BINARY: {
                return this.executeCallWithProgression(() -> {
                    BinaryDownloader binaryDownloader = this.call.getBinaryDownloader().orElseThrow(() -> new RuntimeException("Binary downloader needs to be supplied to download a large binary"));
                    try {
                        SiLABinaryTransfer.GetBinaryInfoResponse binaryInfoResponse = (SiLABinaryTransfer.GetBinaryInfoResponse)cloudierClientObserver.getBinaryInfoResponseRequest(binaryDownloader.getBinaryInfoRequest()).get();
                        int chunkCount = BinaryDownloader.getChunkCount(binaryInfoResponse.getBinarySize());
                        for (int i = 0; i < chunkCount; ++i) {
                            SiLABinaryTransfer.GetChunkResponse getChunkResponse = (SiLABinaryTransfer.GetChunkResponse)cloudierClientObserver.getBinaryChunkRequest(binaryDownloader.getNextChunkDownloadRequest(binaryInfoResponse)).get();
                            binaryDownloader.writeChunk(getChunkResponse);
                        }
                        binaryDownloader.isValidAndCompleteOrThrow();
                        return ProtoMapper.serializeToJson((MessageOrBuilder)binaryInfoResponse);
                    }
                    catch (IOException | InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        throw new RuntimeException("Unknown call type " + (Object)((Object)this.call.getBaseCall().getType()));
    }

    private static Set<SiLACloudConnector.Metadata> getCloudMetadataSet(Map<String, DynamicMessage> metadataMap) {
        return metadataMap.entrySet().stream().map(entry -> SiLACloudConnector.Metadata.newBuilder().setValue(((DynamicMessage)entry.getValue()).toByteString()).setFullyQualifiedMetadataId((String)entry.getKey()).build()).collect(Collectors.toSet());
    }

    String execute() {
        Server server = ServerManager.getInstance().getServers().get(this.call.getBaseCall().getServerId());
        if (server == null) {
            return "";
        }
        if (server.getConnectionType() == Server.ConnectionType.SERVER_INITIATED) {
            CloudierClient cloudierClient = ServerManager.getInstance().getCloudierClient();
            CloudierClientObserver cloudierClientObserver = null;
            if (cloudierClient != null) {
                cloudierClientObserver = (CloudierClientObserver)cloudierClient.getEndpointService().getResponseObservers().get(this.call.getBaseCall().getServerId().toString());
            }
            if (cloudierClientObserver != null) {
                log.debug("Executing cloudier call");
                return this.executeCloudier();
            }
            return "";
        }
        String result = "";
        switch (this.call.getBaseCall().getType()) {
            case UNOBSERVABLE_COMMAND: {
                result = this.executeCallWithProgression(this::executeUnobservableCommand);
                break;
            }
            case OBSERVABLE_COMMAND: {
                result = this.executeCallWithProgression(this::executeObservableCommand);
                break;
            }
            case UNOBSERVABLE_PROPERTY: {
                result = this.executeCallWithProgression(this::getUnobservableProperty);
                break;
            }
            case OBSERVABLE_PROPERTY_READ: 
            case OBSERVABLE_PROPERTY: {
                result = this.executeCallWithProgression(this::getObservableProperty);
                break;
            }
            case GET_FCP_AFFECTED_BY_METADATA: {
                result = this.executeCallWithProgression(this::getFPCAffectedByMetadata);
                break;
            }
            case UPLOAD_BINARY: {
                result = this.executeCallWithProgression(this::uploadBinary);
                break;
            }
            case DOWNLOAD_BINARY: {
                result = this.executeCallWithProgression(this::downloadBinary);
                break;
            }
        }
        return result;
    }

    private String executeCallWithProgression(@NonNull CallExecutor callExecutor) {
        if (callExecutor == null) {
            throw new NullPointerException("callExecutor is marked non-null but is null");
        }
        log.debug("Call {} started", (Object)this.call.getBaseCall().getCallId());
        CallStarted callStarted = new CallStarted(OffsetDateTime.now(), this.call.getTimeout(), this.call.getBaseCall());
        this.callListener.onStart(callStarted);
        try {
            String result = callExecutor.execute();
            log.debug("Call {} ended successfully", (Object)callStarted.getSiLACall().getCallId());
            CallCompleted callCompleted = new CallCompleted(callStarted.getStartDate(), OffsetDateTime.now(), result, this.call.getBaseCall());
            this.callListener.onComplete(callCompleted);
            return result;
        }
        catch (Throwable e) {
            throw this.extractMeaningfulError(errorMessage -> {
                CallErrored callErrored = new CallErrored(callStarted.getStartDate(), OffsetDateTime.now(), (String)errorMessage, this.call.getBaseCall());
                log.debug("Call {} ended with error", (Object)callStarted.getSiLACall().getCallId());
                this.callListener.onError(callErrored);
            }, e);
        }
    }

    private String executeUnobservableCommand() {
        return this.executeCall(this.call.getBaseCall().getCallId(), this.call.getBaseCall().getParameters());
    }

    private String executeObservableCommand() {
        String commandId;
        SiLAFramework.CommandConfirmation.Builder command = SiLAFramework.CommandConfirmation.newBuilder();
        try {
            JsonFormat.parser().merge(this.executeCall(this.call.getBaseCall().getCallId(), this.call.getBaseCall().getParameters()), (Message.Builder)command);
            commandId = ProtoMapper.serializeToJson((MessageOrBuilder)command.getCommandExecutionUUID());
            this.callListener.onObservableCommandInit(this.call.getBaseCall(), command.build());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Received a malformed message");
        }
        AtomicInteger commandStatus = new AtomicInteger(0);
        this.callListener.onObservableCommandExecutionInfo(this.call.getBaseCall(), SiLAFramework.ExecutionInfo.newBuilder().setCommandStatus(SiLAFramework.ExecutionInfo.CommandStatus.waiting).build());
        CompletableFuture<List<String>> stateCommandFuture = this.executeStream(GrpcNameMapper.getStateCommand((String)this.call.getBaseCall().getCallId()), commandId, message -> {
            try {
                SiLAFramework.ExecutionInfo.Builder stateBuilder = SiLAFramework.ExecutionInfo.newBuilder();
                JsonFormat.parser().merge(message, (Message.Builder)stateBuilder);
                log.debug("Received status for call " + this.call.getBaseCall().getCallId());
                log.debug(stateBuilder.toString());
                this.callListener.onObservableCommandExecutionInfo(this.call.getBaseCall(), stateBuilder.build());
                commandStatus.set(stateBuilder.getCommandStatus().getNumber());
                return commandStatus.get() == 1 || commandStatus.get() == 0;
            }
            catch (InvalidProtocolBufferException e) {
                log.warn("Received a malformed message: ", (Throwable)e);
                return false;
            }
        }, false);
        String intermediateCommandName = GrpcNameMapper.getIntermediateCommand((String)this.call.getBaseCall().getCallId());
        Optional<Object> optionalIntermediateResponse = Optional.empty();
        try {
            optionalIntermediateResponse = Optional.of(this.getMethodDescriptor(intermediateCommandName));
        }
        catch (RuntimeException e) {
            log.debug("Call {} does not have intermediate response", (Object)this.call.getBaseCall().getCallId());
        }
        optionalIntermediateResponse.ifPresent(intermediateResponseMethod -> {
            CompletableFuture<List<String>> intermediateResponseFuture = this.executeStream(intermediateCommandName, commandId, message -> {
                try {
                    DynamicMessage.Builder responseType = DynamicMessage.newBuilder((Descriptors.Descriptor)intermediateResponseMethod.getOutputType());
                    JsonFormat.parser().merge(message, (Message.Builder)responseType);
                    log.debug("Received intermediate response for call " + intermediateCommandName);
                    log.debug(responseType.toString());
                    this.callListener.onObservableIntermediateResponse(this.call.getBaseCall(), responseType.build());
                    return true;
                }
                catch (InvalidProtocolBufferException e) {
                    log.warn("Received a malformed message: ", (Throwable)e);
                    return false;
                }
            }, false);
        });
        this.callFuture(stateCommandFuture, null);
        this.callListener.onObservableCommandExecutionInfo(this.call.getBaseCall(), SiLAFramework.ExecutionInfo.newBuilder().setCommandStatus(SiLAFramework.ExecutionInfo.CommandStatus.forNumber((int)commandStatus.get())).build());
        if (commandStatus.get() == 2) {
            return this.executeCall(GrpcNameMapper.getResult((String)this.call.getBaseCall().getCallId()), commandId);
        }
        this.executeCall(GrpcNameMapper.getResult((String)this.call.getBaseCall().getCallId()), commandId);
        throw new RuntimeException("Command finished with an error without further information!");
    }

    private String getUnobservableProperty() {
        return this.executeCall(GrpcNameMapper.getUnobservableProperty((String)this.call.getBaseCall().getCallId()), this.call.getBaseCall().getParameters());
    }

    private String getFPCAffectedByMetadata() {
        return this.executeCall(GrpcNameMapper.getMetadataRPC((String)this.call.getBaseCall().getCallId()), this.call.getBaseCall().getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadBinary() {
        String string;
        block6: {
            BinaryUploader binaryUploader = this.call.getBinaryUploader().orElseThrow(() -> new RuntimeException("Binary uploader needs to be supplied to upload a large binary"));
            ManagedChannel managedChannel = this.call.getConnection().getManagedChannel();
            Context contextWithMetadata = this.createContextWithMetadata(Context.current());
            Context initialContext = null;
            try {
                initialContext = contextWithMetadata.attach();
                BinaryUploadGrpc.BinaryUploadBlockingStub binaryUploadBlockingStub = BinaryUploadGrpc.newBlockingStub((Channel)managedChannel);
                BinaryUploadGrpc.BinaryUploadStub binaryUploadStub = BinaryUploadGrpc.newStub((Channel)managedChannel);
                SiLABinaryTransfer.CreateBinaryResponse createBinaryResponse = binaryUploadBlockingStub.createBinary(binaryUploader.getRequest());
                BinaryUploaderStream binaryUploaderStream = new BinaryUploaderStream(binaryUploader, createBinaryResponse.getBinaryTransferUUID());
                StreamObserver uploadChunkRequestStreamObserver = binaryUploadStub.uploadChunk((StreamObserver)binaryUploaderStream);
                binaryUploaderStream.startUpload((StreamObserver<SiLABinaryTransfer.UploadChunkRequest>)uploadChunkRequestStreamObserver);
                binaryUploaderStream.getVoidCompletableFuture().join();
                string = ProtoMapper.serializeToJson((MessageOrBuilder)createBinaryResponse);
                if (initialContext == null) break block6;
            }
            catch (Throwable throwable) {
                if (initialContext != null) {
                    contextWithMetadata.detach(initialContext);
                }
                throw throwable;
            }
            contextWithMetadata.detach(initialContext);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadBinary() {
        String string;
        block6: {
            BinaryDownloader binaryDownloader = this.call.getBinaryDownloader().orElseThrow(() -> new RuntimeException("Binary downloader needs to be supplied to download a large binary"));
            ManagedChannel managedChannel = this.call.getConnection().getManagedChannel();
            Context contextWithMetadata = this.createContextWithMetadata(Context.current());
            Context initialContext = null;
            try {
                initialContext = contextWithMetadata.attach();
                BinaryDownloadGrpc.BinaryDownloadBlockingStub binaryDownloadBlockingStub = BinaryDownloadGrpc.newBlockingStub((Channel)managedChannel);
                BinaryDownloadGrpc.BinaryDownloadStub binaryDownloadStub = BinaryDownloadGrpc.newStub((Channel)managedChannel);
                SiLABinaryTransfer.GetBinaryInfoResponse binaryInfo = binaryDownloadBlockingStub.getBinaryInfo(binaryDownloader.getBinaryInfoRequest());
                BinaryDownloaderStream binaryDownloaderStream = new BinaryDownloaderStream(binaryDownloader, binaryInfo);
                StreamObserver getChunkRequestStreamObserver = binaryDownloadStub.getChunk((StreamObserver)binaryDownloaderStream);
                binaryDownloaderStream.startDownload((StreamObserver<SiLABinaryTransfer.GetChunkRequest>)getChunkRequestStreamObserver);
                binaryDownloaderStream.getVoidCompletableFuture().join();
                binaryDownloader.isValidAndCompleteOrThrow();
                string = ProtoMapper.serializeToJson((MessageOrBuilder)binaryInfo);
                if (initialContext == null) break block6;
            }
            catch (Throwable throwable) {
                if (initialContext != null) {
                    contextWithMetadata.detach(initialContext);
                }
                throw throwable;
            }
            contextWithMetadata.detach(initialContext);
        }
        return string;
    }

    private String getObservableProperty() {
        CompletableFuture<List<String>> future = this.executeStream(GrpcNameMapper.getObservableProperty((String)this.call.getBaseCall().getCallId()), this.call.getBaseCall().getParameters(), message -> {
            this.callListener.onObservablePropertyUpdate(this.call.getBaseCall(), message);
            return this.call.getBaseCall().getType().equals((Object)SiLACall.Type.OBSERVABLE_PROPERTY);
        }, true);
        List<String> results = this.callFuture(future, null);
        if (results.isEmpty()) {
            throw new RuntimeException("No result");
        }
        return results.get(results.size() - 1);
    }

    private <T> T callFuture(@NonNull Future<T> future, @Nullable Consumer<String> errorConsumer) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        try {
            return future.get(this.call.getTimeout().get(ChronoUnit.SECONDS), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            if (!future.isDone()) {
                future.cancel(true);
            }
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw this.extractMeaningfulError(errorConsumer, e);
        }
    }

    private RuntimeException extractMeaningfulError(Consumer<String> errorConsumer, Throwable e) {
        String errorMessage;
        Throwable relevantThrowable = e;
        if (relevantThrowable.getCause() != null) {
            relevantThrowable = relevantThrowable.getCause();
        }
        if (relevantThrowable instanceof SiLAErrorException) {
            try {
                errorMessage = JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)((SiLAErrorException)relevantThrowable).getSiLAError());
            }
            catch (InvalidProtocolBufferException ex) {
                errorMessage = ((SiLAErrorException)relevantThrowable).getSiLAError().toString();
            }
        } else {
            errorMessage = ExceptionGeneration.generateMessage((Throwable)relevantThrowable, (Duration)this.call.getTimeout());
        }
        if (errorConsumer != null) {
            errorConsumer.accept(errorMessage);
        }
        if (relevantThrowable instanceof SiLAErrorException) {
            return (SiLAErrorException)relevantThrowable;
        }
        return new RuntimeException(relevantThrowable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeCall(@NonNull String callId, @NonNull String params) {
        String string;
        if (callId == null) {
            throw new NullPointerException("callId is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Descriptors.MethodDescriptor method = this.getMethodDescriptor(callId);
        DynamicMessage request = ServerCallExecutor.getRequestMessage(method, params);
        MethodDescriptor<Object, Object> methodDescriptor = ServerCallExecutor.getMethodDescriptor(method);
        Context contextWithMetadata = this.createContextWithMetadata(Context.current());
        Context initialContext = contextWithMetadata.attach();
        try {
            ClientCall clientCall = this.call.getConnection().getManagedChannel().newCall(methodDescriptor, CallOptions.DEFAULT.withDeadlineAfter(this.call.getTimeout().getSeconds(), TimeUnit.SECONDS));
            DynamicMessage unaryCall = (DynamicMessage)ClientCalls.blockingUnaryCall((ClientCall)clientCall, (Object)request);
            string = ProtoMapper.serializeToJson((MessageOrBuilder)unaryCall);
        }
        catch (Throwable throwable) {
            try {
                contextWithMetadata.detach(initialContext);
                throw throwable;
            }
            catch (Throwable e) {
                if (e instanceof StatusRuntimeException) {
                    SiLAErrors.retrieveSiLAError((StatusRuntimeException)((StatusRuntimeException)e)).ifPresent(siLAError -> {
                        throw new SiLAErrorException(siLAError, ((StatusRuntimeException)e).getStatus());
                    });
                }
                throw new RuntimeException(ExceptionGeneration.generateMessage((Throwable)e, (Duration)this.call.getTimeout()));
            }
        }
        contextWithMetadata.detach(initialContext);
        return string;
    }

    private Context createContextWithMetadata(Context originalContext) {
        Context contextWithMetadata = originalContext;
        Map<String, DynamicMessage> metadataMap = this.getMetadataMap();
        HashSet contextKeySet = new HashSet();
        for (Map.Entry<String, DynamicMessage> entry : metadataMap.entrySet()) {
            Context.Key contextKey = Context.key((String)entry.getKey());
            contextKeySet.add(new FullyQualifiedMetadataContextKey(entry.getKey(), contextKey));
            contextWithMetadata = contextWithMetadata.withValue(contextKey, (Object)entry.getValue());
        }
        contextWithMetadata = contextWithMetadata.withValue(Constants.METADATA_IDENTIFIERS_CTX_KEY, contextKeySet);
        return contextWithMetadata;
    }

    private Map<String, DynamicMessage> getMetadataMap() {
        if (!this.call.getBaseCall().getMetadatas().isEmpty() && !this.call.getBaseCall().getMetadatas().equals("{}")) {
            try {
                JsonParser parser = new JsonParser();
                JsonElement rootNode = parser.parse(this.call.getBaseCall().getMetadatas());
                HashMap<String, DynamicMessage> metadataMap = new HashMap<String, DynamicMessage>();
                if (rootNode.isJsonObject()) {
                    for (Map.Entry entry : rootNode.getAsJsonObject().entrySet()) {
                        String[] qualifiers = ((String)entry.getKey()).split("/");
                        if (qualifiers.length < 6) {
                            log.warn("Invalid metadata identifier {}", entry.getKey());
                            continue;
                        }
                        String fullyQualifiedFeatureIdentifier = qualifiers[0] + '/' + qualifiers[1] + '/' + qualifiers[2] + '/' + qualifiers[3];
                        String metadataIdentifier = qualifiers[5];
                        Descriptors.FileDescriptor fileDescriptor = this.call.getConnection().getFileDescriptorMap().get(fullyQualifiedFeatureIdentifier);
                        Descriptors.Descriptor messageTypeByName = fileDescriptor.findMessageTypeByName(GrpcNameMapper.getMetadata((String)metadataIdentifier));
                        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)messageTypeByName);
                        JsonFormat.parser().merge(((JsonElement)entry.getValue()).toString(), (Message.Builder)messageBuilder);
                        metadataMap.put((String)entry.getKey(), messageBuilder.build());
                    }
                }
                return metadataMap;
            }
            catch (InvalidProtocolBufferException e) {
                log.warn("Malformed metadata value", (Throwable)e);
            }
            catch (NullPointerException e) {
                log.warn("Unknown metadata received", (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    private CompletableFuture<List<String>> executeStream(@NonNull String callId, @NonNull String params, @Nullable StreamCallback callback, boolean storeResult) {
        if (callId == null) {
            throw new NullPointerException("callId is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Descriptors.MethodDescriptor method = this.getMethodDescriptor(callId);
        DynamicMessage request = ServerCallExecutor.getRequestMessage(method, params);
        MethodDescriptor<Object, Object> methodDescriptor = ServerCallExecutor.getMethodDescriptor(method);
        ClientCall clientCall = this.call.getConnection().getManagedChannel().newCall(methodDescriptor, CallOptions.DEFAULT.withDeadlineAfter(this.call.getTimeout().getSeconds(), TimeUnit.SECONDS));
        this.internalCalls.add((ClientCall<Object, Object>)clientCall);
        StaticStreamObserver propertyObserver = new StaticStreamObserver((ClientCall<Object, Object>)clientCall, callback, storeResult);
        CompletableFuture<List<String>> future = propertyObserver.getFuture();
        this.internalFutures.add(future);
        ClientCalls.asyncServerStreamingCall((ClientCall)clientCall, (Object)request, (StreamObserver)propertyObserver);
        return future;
    }

    private Descriptors.MethodDescriptor getMethodDescriptor(String callId) {
        if (!this.call.getFeature().isPresent()) {
            throw new RuntimeException("Call requires a feature but Optional is empty");
        }
        Descriptors.MethodDescriptor method = this.call.getFeature().get().findMethodByName(callId);
        if (method == null) {
            throw new RuntimeException("Server " + this.call.getBaseCall().getServerId() + " doesn't expose call to " + callId);
        }
        return method;
    }

    private static MethodDescriptor<Object, Object> getMethodDescriptor(@NonNull Descriptors.MethodDescriptor method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(ServerCallExecutor.getFullMethodName(method)).setRequestMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(method.getInputType())).setResponseMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(method.getOutputType())).build();
    }

    private static String getFullMethodName(@NonNull Descriptors.MethodDescriptor method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return MethodDescriptor.generateFullMethodName((String)method.getService().getFullName(), (String)method.getName());
    }

    private static DynamicMessage getRequestMessage(@NonNull Descriptors.MethodDescriptor method, @NonNull String params) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        DynamicMessage.Builder parBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)method.getInputType());
        try {
            JsonFormat.parser().merge(params, (Message.Builder)parBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return parBuilder.build();
    }

    private static DynamicMessage getRequestResponse(@NonNull Descriptors.MethodDescriptor method, @NonNull ByteString response) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        DynamicMessage.Builder parBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)method.getOutputType());
        try {
            parBuilder.mergeFrom(response);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return parBuilder.build();
    }

    public ServerCallExecutor(ExecutableServerCall call, CallListener callListener) {
        this.call = call;
        this.callListener = callListener;
    }

    private static interface CallExecutor {
        public String execute();
    }
}

