/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.server_management;

import com.google.protobuf.Descriptors;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.security.KeyException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.models.Feature;
import sila_java.library.core.sila.mapping.feature.FeatureGenerator;
import sila_java.library.core.sila.mapping.feature.MalformedSiLAFeature;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.manager.models.Server;

public class Connection
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Connection.class);
    private final UUID serverId;
    private final Map<String, Descriptors.ServiceDescriptor> featureMap = new HashMap<String, Descriptors.ServiceDescriptor>();
    private final Map<String, Descriptors.FileDescriptor> fileDescriptorMap = new HashMap<String, Descriptors.FileDescriptor>();
    private final ManagedChannel managedChannel;
    private final AutoCloseable closeConnection;

    public Connection(@NonNull Server server, @NonNull ManagedChannel managedChannel) throws MalformedSiLAFeature {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (managedChannel == null) {
            throw new NullPointerException("managedChannel is marked non-null but is null");
        }
        this.serverId = server.getConfiguration().getUuid();
        this.managedChannel = managedChannel;
        this.closeConnection = () -> {
            try {
                managedChannel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage());
            }
        };
        this.loadFeaturesFromServer(server);
    }

    private void loadFeaturesFromServer(Server server) throws MalformedSiLAFeature {
        for (Feature feature : server.getFeatures()) {
            String fullyQualifiedIdentifier = FeatureGenerator.generateFullyQualifiedIdentifier((Feature)feature);
            Descriptors.FileDescriptor protoFile = ProtoMapper.usingFeature((Feature)feature).generateProto();
            this.fileDescriptorMap.put(fullyQualifiedIdentifier, protoFile);
            this.featureMap.put(fullyQualifiedIdentifier, (Descriptors.ServiceDescriptor)protoFile.getServices().get(0));
        }
    }

    public Connection(@NonNull Server server, @NonNull AutoCloseable closeable) throws MalformedSiLAFeature {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (closeable == null) {
            throw new NullPointerException("closeable is marked non-null but is null");
        }
        this.serverId = server.getConfiguration().getUuid();
        this.managedChannel = null;
        this.closeConnection = closeable;
        this.loadFeaturesFromServer(server);
    }

    public void attachAndTriggerListener(final @NonNull ConnectionListener connectionListener) {
        if (connectionListener == null) {
            throw new NullPointerException("connectionListener is marked non-null but is null");
        }
        this.managedChannel.notifyWhenStateChanged(this.managedChannel.getState(false), new Runnable(){

            @Override
            public void run() {
                ConnectivityState state = Connection.this.managedChannel.getState(false);
                log.debug("state of server with id `{}` is `{}`", (Object)Connection.this.serverId, (Object)state.name());
                connectionListener.connectionChanged(Connection.this.serverId, Connection.this.managedChannel);
                Connection.this.managedChannel.notifyWhenStateChanged(state, (Runnable)this);
            }
        });
        connectionListener.connectionChanged(this.serverId, this.managedChannel);
    }

    public Descriptors.ServiceDescriptor getFeatureService(@NonNull String fullyQualifiedFeatureId) throws KeyException {
        if (fullyQualifiedFeatureId == null) {
            throw new NullPointerException("fullyQualifiedFeatureId is marked non-null but is null");
        }
        if (!this.featureMap.containsKey(fullyQualifiedFeatureId)) {
            throw new KeyException("Cannot find feature: " + fullyQualifiedFeatureId);
        }
        return this.featureMap.get(fullyQualifiedFeatureId);
    }

    @Override
    public void close() {
        try {
            this.closeConnection.close();
        }
        catch (Exception e) {
            log.warn("Exception occured while closing connection of server {}", (Object)this.serverId, (Object)e);
        }
    }

    public Map<String, Descriptors.FileDescriptor> getFileDescriptorMap() {
        return this.fileDescriptorMap;
    }

    public ManagedChannel getManagedChannel() {
        return this.managedChannel;
    }

    public static interface ConnectionListener {
        public void connectionChanged(UUID var1, ManagedChannel var2);
    }
}

