/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.asynchronous.MethodPoller;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.models.Server;

public class ServerFinder {
    private static final Logger log = LoggerFactory.getLogger(ServerFinder.class);
    private final ServerManager serverManager = ServerManager.getInstance();
    private final Predicate<Server> filterPredicate;

    public static ServerFinder filterBy(Filter ... filters) {
        return new ServerFinder(filters);
    }

    public List<Server> find() {
        return this.matchingServers().collect(Collectors.toList());
    }

    public Optional<Server> findOne() {
        return this.matchingServers().findAny();
    }

    public Optional<Server> scanAndFindOne(@NonNull Duration timeout) {
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        try {
            return Optional.of(MethodPoller.await().atMost(timeout).withInterval(Duration.ZERO).untilPresent(() -> {
                Optional<Server> optionalServer = this.findOne();
                if (optionalServer.isPresent()) {
                    return optionalServer;
                }
                this.serverManager.getDiscovery().scanNetwork(1);
                return Optional.empty();
            }));
        }
        catch (ExecutionException | TimeoutException e) {
            return Optional.empty();
        }
    }

    private Stream<Server> matchingServers() {
        return this.serverManager.getServers().values().stream().filter(this.filterPredicate);
    }

    private static boolean hasDuplicateFilter(@NonNull Collection<Filter> filters) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return filters.stream().map(Filter::getType).collect(Collectors.toSet()).size() != filters.size();
    }

    private ServerFinder(Filter ... filters) {
        if (filters.length == 0) {
            this.filterPredicate = x -> true;
        } else {
            List<Filter> filterList = Arrays.asList(filters);
            if (ServerFinder.hasDuplicateFilter(filterList)) {
                throw new RuntimeException("Duplicate filters found, there can only be one type of filter");
            }
            this.filterPredicate = filterList.stream().map(filter -> ((Filter)filter).predicate).reduce(Predicate::and).orElse(x -> true);
        }
    }

    public static class Filter {
        private final Type type;
        private final Predicate<Server> predicate;

        public static Filter uuid(@NonNull UUID uuid) {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            return new Filter(Type.UUID, server -> server.getConfiguration().getUuid().equals(uuid));
        }

        public static Filter type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            return new Filter(Type.TYPE, server -> server.getInformation().getType().equals(type));
        }

        public static Filter name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            return new Filter(Type.NAME, server -> server.getConfiguration().getName().equals(name));
        }

        public static Filter host(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            return new Filter(Type.HOST, server -> server.getHost().equals(host));
        }

        public static Filter port(int port) {
            return new Filter(Type.PORT, server -> server.getPort() == port);
        }

        public static Filter status(@NonNull Server.Status status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            return new Filter(Type.STATUS, server -> server.getStatus().equals((Object)status));
        }

        public static Filter custom(@NonNull Predicate<Server> customPredicate) {
            if (customPredicate == null) {
                throw new NullPointerException("customPredicate is marked non-null but is null");
            }
            return new Filter(Type.CUSTOM, customPredicate);
        }

        public Type getType() {
            return this.type;
        }

        public Predicate<Server> getPredicate() {
            return this.predicate;
        }

        private Filter(Type type, Predicate<Server> predicate) {
            this.type = type;
            this.predicate = predicate;
        }

        private static enum Type {
            NAME,
            TYPE,
            HOST,
            PORT,
            STATUS,
            CUSTOM,
            UUID;

        }
    }
}

