/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import sila2.org.silastandard.SiLABinaryTransfer;

public class BinaryUploader {
    private static final int MAX_CHUNK_SIZE = 0x200000;
    private final InputStream inputStream;
    private final SiLABinaryTransfer.CreateBinaryRequest request;
    private int chunkIndex = 0;

    public BinaryUploader(@NonNull InputStream inputStream, long totalByteSize, @NonNull String parameterIdentifier) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (parameterIdentifier == null) {
            throw new NullPointerException("parameterIdentifier is marked non-null but is null");
        }
        this.inputStream = inputStream;
        this.request = BinaryUploader.getBinaryRequest(totalByteSize, BinaryUploader.getChunkCount(totalByteSize), parameterIdentifier);
    }

    public BinaryUploader(@NonNull List<InputStream> inputStream, long totalByteSize, @NonNull String parameterIdentifier) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (parameterIdentifier == null) {
            throw new NullPointerException("parameterIdentifier is marked non-null but is null");
        }
        this.inputStream = new SequenceInputStream(Collections.enumeration(inputStream));
        this.request = BinaryUploader.getBinaryRequest(totalByteSize, BinaryUploader.getChunkCount(totalByteSize), parameterIdentifier);
    }

    public synchronized SiLABinaryTransfer.UploadChunkRequest getNextChunkUploadRequest(@NonNull String binaryTransferUUID) throws IOException {
        if (binaryTransferUUID == null) {
            throw new NullPointerException("binaryTransferUUID is marked non-null but is null");
        }
        if (this.request.getChunkCount() == this.chunkIndex - 1) {
            throw new IOException("End of binary upload stream");
        }
        int chunkSizeModulo = (int)(this.request.getBinarySize() % 0x200000L);
        byte[] bytes = new byte[0x200000];
        int lengthToRead = this.chunkIndex == this.request.getChunkCount() - 1 && chunkSizeModulo > 0 ? chunkSizeModulo : 0x200000;
        this.inputStream.read(bytes, 0, lengthToRead);
        ByteString byteString = ByteString.copyFrom((byte[])bytes, (int)0, (int)lengthToRead);
        SiLABinaryTransfer.UploadChunkRequest uploadChunkRequest = SiLABinaryTransfer.UploadChunkRequest.newBuilder().setPayload(byteString).setChunkIndex(this.chunkIndex).setBinaryTransferUUID(binaryTransferUUID).build();
        ++this.chunkIndex;
        return uploadChunkRequest;
    }

    public int getChunkCount() {
        return this.getRequest().getChunkCount();
    }

    public long getBinarySize() {
        return this.getRequest().getBinarySize();
    }

    public String getParameterIdentifier() {
        return this.getRequest().getParameterIdentifier();
    }

    public static SiLABinaryTransfer.CreateBinaryRequest getBinaryRequest(long totalByteSize, int chunkCount, @NonNull String parameterIdentifier) {
        if (parameterIdentifier == null) {
            throw new NullPointerException("parameterIdentifier is marked non-null but is null");
        }
        return SiLABinaryTransfer.CreateBinaryRequest.newBuilder().setBinarySize(totalByteSize).setChunkCount(chunkCount).setParameterIdentifier(parameterIdentifier).build();
    }

    public static int getChunkCount(long totalByteSize) {
        int chunkSizeModulo = (int)(totalByteSize % 0x200000L);
        return (int)(totalByteSize / 0x200000L) + (chunkSizeModulo > 0 ? 1 : 0);
    }

    public SiLABinaryTransfer.CreateBinaryRequest getRequest() {
        return this.request;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }
}

