/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor.stream;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.ClientCall;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;
import lombok.NonNull;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.manager.executor.stream.StreamCallback;
import sila_java.library.manager.executor.stream.StreamCancellationException;

public final class StaticStreamObserver
implements StreamObserver<Object> {
    private final ConcurrentLinkedDeque<String> resultsList = new ConcurrentLinkedDeque();
    private final CompletableFuture<List<String>> future = new CompletableFuture();
    private final ClientCall<Object, Object> clientCall;
    private final StreamCallback callback;
    private final boolean storeResult;

    public StaticStreamObserver(@NonNull ClientCall<Object, Object> clientCall, @Nullable StreamCallback callback) {
        this(clientCall, callback, true);
        if (clientCall == null) {
            throw new NullPointerException("clientCall is marked non-null but is null");
        }
    }

    public StaticStreamObserver(@NonNull ClientCall<Object, Object> clientCall, @Nullable StreamCallback callback, boolean storeResult) {
        if (clientCall == null) {
            throw new NullPointerException("clientCall is marked non-null but is null");
        }
        this.clientCall = clientCall;
        this.callback = callback;
        this.storeResult = storeResult;
    }

    public void onNext(Object message) {
        if (this.future.isDone()) {
            return;
        }
        try {
            String json = ProtoMapper.serializeToJson((MessageOrBuilder)((DynamicMessage)message));
            if (this.storeResult) {
                this.resultsList.add(json);
            }
            if (this.callback != null && !this.callback.onNext(json)) {
                this.clientCall.cancel(null, (Throwable)new StreamCancellationException());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.onError(new IllegalArgumentException(e.getMessage()));
        }
    }

    public void onError(Throwable throwable) {
        if (this.future.isDone()) {
            return;
        }
        if (throwable.getCause() instanceof StreamCancellationException) {
            this.onCompleted();
        } else {
            this.future.completeExceptionally(throwable);
        }
    }

    public void onCompleted() {
        if (this.future.isDone()) {
            return;
        }
        if (!this.storeResult) {
            this.future.complete(null);
        } else {
            this.future.complete(new ArrayList<String>(this.resultsList));
        }
    }

    public CompletableFuture<List<String>> getFuture() {
        return this.future;
    }
}

