/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import com.google.protobuf.DynamicMessage;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.manager.grpc.Constants;

public class DefaultClientCallMetadataInjector
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultClientCallMetadataInjector.class);

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (Constants.METADATA_IDENTIFIERS_CTX_KEY.get() != null) {
                    ((Set)Constants.METADATA_IDENTIFIERS_CTX_KEY.get()).forEach(contextKey -> headers.put(Metadata.Key.of((String)String.format("sila-%s-bin", contextKey.getFullyQualifiedIdentifier().replace("/", "-").toLowerCase(Locale.ROOT)), (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER), (Object)((DynamicMessage)contextKey.getContextKey().get()).toByteArray()));
                }
                super.start(responseListener, headers);
            }
        };
    }
}

