/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.models;

import java.util.UUID;
import lombok.NonNull;
import sila_java.library.core.sila.utils.FullyQualifiedIdentifierUtils;

public class SiLACall {
    private final UUID identifier;
    private final UUID serverId;
    private final String fullyQualifiedFeatureId;
    private final String callId;
    private final Type type;
    private final String parameters;
    private final String metadatas;

    public static SiLACall fromBinaryDownload(@NonNull UUID serverId) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        return new SiLACall(serverId, "", "", Type.DOWNLOAD_BINARY);
    }

    public SiLACall(@NonNull UUID serverId, @NonNull String fullyQualifiedFeatureId, @NonNull String callId, @NonNull Type type, @NonNull String parameters) {
        this(UUID.randomUUID(), serverId, fullyQualifiedFeatureId, callId, type, parameters, "{}");
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (fullyQualifiedFeatureId == null) {
            throw new NullPointerException("fullyQualifiedFeatureId is marked non-null but is null");
        }
        if (callId == null) {
            throw new NullPointerException("callId is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
    }

    public SiLACall(@NonNull UUID serverId, @NonNull String fullyQualifiedFeatureId, @NonNull String callId, @NonNull Type type) {
        this(serverId, fullyQualifiedFeatureId, callId, type, "{}");
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (fullyQualifiedFeatureId == null) {
            throw new NullPointerException("fullyQualifiedFeatureId is marked non-null but is null");
        }
        if (callId == null) {
            throw new NullPointerException("callId is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public SiLACall(@NonNull SiLACall siLACall) {
        this(siLACall.identifier, siLACall.serverId, siLACall.fullyQualifiedFeatureId, siLACall.callId, siLACall.type, siLACall.parameters, siLACall.metadatas);
        if (siLACall == null) {
            throw new NullPointerException("siLACall is marked non-null but is null");
        }
    }

    public SiLACall(@NonNull UUID identifier, @NonNull UUID serverId, @NonNull String fullyQualifiedFeatureId, @NonNull String callId, @NonNull Type type, @NonNull String parameters, @NonNull String metadatas) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (fullyQualifiedFeatureId == null) {
            throw new NullPointerException("fullyQualifiedFeatureId is marked non-null but is null");
        }
        if (callId == null) {
            throw new NullPointerException("callId is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (metadatas == null) {
            throw new NullPointerException("metadatas is marked non-null but is null");
        }
        if (type != Type.DOWNLOAD_BINARY && !FullyQualifiedIdentifierUtils.FullyQualifiedFeatureIdentifierPattern.matcher(fullyQualifiedFeatureId).matches()) {
            throw new RuntimeException("Provided fully qualified feature identifier is invalid");
        }
        this.identifier = identifier;
        this.serverId = serverId;
        this.fullyQualifiedFeatureId = fullyQualifiedFeatureId;
        this.callId = callId;
        this.type = type;
        this.parameters = parameters;
        this.metadatas = metadatas;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public UUID getServerId() {
        return this.serverId;
    }

    public String getFullyQualifiedFeatureId() {
        return this.fullyQualifiedFeatureId;
    }

    public String getCallId() {
        return this.callId;
    }

    public Type getType() {
        return this.type;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getMetadatas() {
        return this.metadatas;
    }

    public static class Builder {
        private final UUID serverId;
        private final String fullyQualifiedFeatureId;
        private final String callId;
        private final Type type;
        private UUID identifier = UUID.randomUUID();
        private String parameters = "{}";
        private String metadatas = "{}";

        public Builder(@NonNull UUID serverId, @NonNull String fullyQualifiedFeatureId, @NonNull String callId, @NonNull Type type) {
            if (serverId == null) {
                throw new NullPointerException("serverId is marked non-null but is null");
            }
            if (fullyQualifiedFeatureId == null) {
                throw new NullPointerException("fullyQualifiedFeatureId is marked non-null but is null");
            }
            if (callId == null) {
                throw new NullPointerException("callId is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.serverId = serverId;
            this.fullyQualifiedFeatureId = fullyQualifiedFeatureId;
            this.callId = callId;
            this.type = type;
        }

        public Builder withParameters(@NonNull String parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            this.parameters = parameters;
            return this;
        }

        public Builder withIdentifier(@NonNull UUID identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            this.identifier = identifier;
            return this;
        }

        public Builder withMetadata(@NonNull String metadatas) {
            if (metadatas == null) {
                throw new NullPointerException("metadatas is marked non-null but is null");
            }
            this.metadatas = metadatas;
            return this;
        }

        public SiLACall build() {
            return new SiLACall(this.identifier, this.serverId, this.fullyQualifiedFeatureId, this.callId, this.type, this.parameters, this.metadatas);
        }
    }

    public static enum Type {
        UNOBSERVABLE_COMMAND,
        OBSERVABLE_COMMAND,
        UNOBSERVABLE_PROPERTY,
        OBSERVABLE_PROPERTY,
        OBSERVABLE_PROPERTY_READ,
        GET_FCP_AFFECTED_BY_METADATA,
        UPLOAD_BINARY,
        DOWNLOAD_BINARY;

    }
}

