/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import com.google.protobuf.Descriptors;
import java.security.KeyException;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.executor.BinaryDownloader;
import sila_java.library.manager.executor.BinaryUploader;
import sila_java.library.manager.models.SiLACall;
import sila_java.library.manager.server_management.Connection;

public class ExecutableServerCall {
    private static final Logger log = LoggerFactory.getLogger(ExecutableServerCall.class);
    private static final Duration DEFAULT_CALL_TIMEOUT = Duration.ofMillis(Long.MAX_VALUE);
    private final Connection connection;
    private final SiLACall baseCall;
    private final Optional<Descriptors.ServiceDescriptor> feature;
    private final Duration timeout;
    private final Optional<BinaryUploader> binaryUploader;
    private final Optional<BinaryDownloader> binaryDownloader;
    private final Optional<UUID> binaryUuid;

    public static Builder newBuilder(@NonNull Connection connection, @NonNull SiLACall baseCall) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (baseCall == null) {
            throw new NullPointerException("baseCall is marked non-null but is null");
        }
        return new Builder(connection, baseCall);
    }

    public static ExecutableServerCall newInstance(@NonNull SiLACall siLACall) {
        if (siLACall == null) {
            throw new NullPointerException("siLACall is marked non-null but is null");
        }
        return ExecutableServerCall.newBuilder(siLACall).build();
    }

    public static Builder newBuilder(@NonNull SiLACall siLACall) {
        if (siLACall == null) {
            throw new NullPointerException("siLACall is marked non-null but is null");
        }
        return ExecutableServerCall.newBuilder(ServerManager.getInstance().getConnections().get(siLACall.getServerId()), siLACall);
    }

    private ExecutableServerCall(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.connection = builder.connection;
        this.baseCall = builder.baseCall;
        this.feature = builder.feature;
        this.timeout = builder.timeout;
        this.binaryUploader = builder.binaryUploader;
        this.binaryDownloader = builder.binaryDownloader;
        this.binaryUuid = builder.binaryUuid;
        if (this.timeout.isZero() || this.timeout.isNegative()) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SiLACall getBaseCall() {
        return this.baseCall;
    }

    public Optional<Descriptors.ServiceDescriptor> getFeature() {
        return this.feature;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Optional<BinaryUploader> getBinaryUploader() {
        return this.binaryUploader;
    }

    public Optional<BinaryDownloader> getBinaryDownloader() {
        return this.binaryDownloader;
    }

    public Optional<UUID> getBinaryUuid() {
        return this.binaryUuid;
    }

    static /* synthetic */ Duration access$000() {
        return DEFAULT_CALL_TIMEOUT;
    }

    public static class Builder {
        private final Connection connection;
        private final SiLACall baseCall;
        private final Optional<Descriptors.ServiceDescriptor> feature;
        private Duration timeout = ExecutableServerCall.access$000();
        private Optional<BinaryUploader> binaryUploader = Optional.empty();
        private Optional<BinaryDownloader> binaryDownloader = Optional.empty();
        private Optional<UUID> binaryUuid = Optional.empty();

        private Builder(@NonNull Connection connection, @NonNull SiLACall baseCall) {
            if (connection == null) {
                throw new NullPointerException("connection is marked non-null but is null");
            }
            if (baseCall == null) {
                throw new NullPointerException("baseCall is marked non-null but is null");
            }
            this.connection = connection;
            this.baseCall = baseCall;
            Descriptors.ServiceDescriptor featureService = null;
            if (this.baseCall.getType() != SiLACall.Type.DOWNLOAD_BINARY) {
                try {
                    featureService = this.connection.getFeatureService(baseCall.getFullyQualifiedFeatureId());
                }
                catch (KeyException e) {
                    log.warn("Unable to find feature with {}, call will be performed feature-less", (Object)baseCall.getFullyQualifiedFeatureId());
                }
            }
            this.feature = Optional.ofNullable(featureService);
        }

        public ExecutableServerCall build() {
            return new ExecutableServerCall(this);
        }

        public Builder withTimeout(@NonNull Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder withBinaryUploader(@NonNull BinaryUploader binaryUploader) {
            if (binaryUploader == null) {
                throw new NullPointerException("binaryUploader is marked non-null but is null");
            }
            this.binaryUploader = Optional.of(binaryUploader);
            return this;
        }

        public Builder withBinaryDownloader(@NonNull BinaryDownloader binaryDownloader) {
            if (binaryDownloader == null) {
                throw new NullPointerException("binaryDownloader is marked non-null but is null");
            }
            this.binaryDownloader = Optional.of(binaryDownloader);
            return this;
        }

        public Builder withBinaryUUID(@NonNull UUID binaryUUID) {
            if (binaryUUID == null) {
                throw new NullPointerException("binaryUUID is marked non-null but is null");
            }
            this.binaryUuid = Optional.of(binaryUUID);
            return this;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public SiLACall getBaseCall() {
            return this.baseCall;
        }

        public Optional<Descriptors.ServiceDescriptor> getFeature() {
            return this.feature;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Optional<BinaryUploader> getBinaryUploader() {
            return this.binaryUploader;
        }

        public Optional<BinaryDownloader> getBinaryDownloader() {
            return this.binaryDownloader;
        }

        public Optional<UUID> getBinaryUuid() {
            return this.binaryUuid;
        }
    }
}

