/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.DynamicMessage;
import io.grpc.ManagedChannelBuilder;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.clients.ChannelBuilder;
import sila_java.library.manager.executor.CallListener;
import sila_java.library.manager.executor.ExecutableServerCall;
import sila_java.library.manager.executor.ServerCallExecutor;
import sila_java.library.manager.models.CallCompleted;
import sila_java.library.manager.models.CallErrored;
import sila_java.library.manager.models.CallStarted;
import sila_java.library.manager.models.SiLACall;

public class ServerCallManager {
    private static final Logger log = LoggerFactory.getLogger(ServerCallManager.class);
    private static final ExecutorService executor = new ThreadPoolExecutor(1, 32, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("sila-call-exec-%d").setDaemon(true).build());
    private static final CallListener NO_OP_CALL_LISTENER = new CallListener(){};
    private final Map<UUID, RunningServerCall> calls = new ConcurrentHashMap<UUID, RunningServerCall>();
    private final List<CallListener> callManagerListeners = new CopyOnWriteArrayList<CallListener>();

    @Deprecated
    public ManagedChannelBuilder<?> newChannelBuilderWithoutEncryption(@NonNull String host, int port) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        return ChannelBuilder.withoutEncryption((String)host, (int)port).executor((Executor)executor);
    }

    public ManagedChannelBuilder<?> newChannelBuilderWithEncryption(@NonNull String host, int port) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        return ChannelBuilder.withTLSEncryption((String)host, (int)port).executor((Executor)executor);
    }

    public ManagedChannelBuilder<?> newChannelBuilderWithEncryption(@NonNull String host, int port, X509Certificate certificate) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        return ChannelBuilder.withTLSEncryption((String)host, (int)port, (X509Certificate)certificate).executor((Executor)executor);
    }

    public Optional<RunningServerCall> getCall(@NonNull UUID callUuid) {
        if (callUuid == null) {
            throw new NullPointerException("callUuid is marked non-null but is null");
        }
        return Optional.ofNullable(this.calls.get(callUuid));
    }

    public Collection<RunningServerCall> getCalls() {
        return this.calls.values();
    }

    public Future<String> runAsync(@NonNull ExecutableServerCall executableServerCall, boolean notifyGlobalListener, @Nullable CallListener callRelativeListener) {
        if (executableServerCall == null) {
            throw new NullPointerException("executableServerCall is marked non-null but is null");
        }
        UUID callUuid = executableServerCall.getBaseCall().getIdentifier();
        CallListener callListener = notifyGlobalListener ? (callRelativeListener == null ? new EventForwarder() : new EventForwarder(callRelativeListener)) : (callRelativeListener == null ? NO_OP_CALL_LISTENER : callRelativeListener);
        Future<String> future = executor.submit(() -> {
            try {
                try (ServerCallExecutor callExecutor = new ServerCallExecutor(executableServerCall, callListener);){
                    String string = callExecutor.execute();
                    return string;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                log.debug("Removing call {} from call manager", (Object)callUuid);
                this.calls.remove(callUuid);
            }
        });
        log.debug("New call {} addition into call manager", (Object)callUuid);
        this.calls.put(callUuid, new RunningServerCall(executableServerCall, future));
        return future;
    }

    public Future<String> runAsync(@NonNull ExecutableServerCall executableServerCall, @Nullable CallListener callRelativeListener) {
        if (executableServerCall == null) {
            throw new NullPointerException("executableServerCall is marked non-null but is null");
        }
        return this.runAsync(executableServerCall, true, callRelativeListener);
    }

    public Future<String> runAsync(@NonNull ExecutableServerCall executableServerCall) {
        if (executableServerCall == null) {
            throw new NullPointerException("executableServerCall is marked non-null but is null");
        }
        return this.runAsync(executableServerCall, null);
    }

    public Runnable addListener(@NonNull CallListener callListener) {
        if (callListener == null) {
            throw new NullPointerException("callListener is marked non-null but is null");
        }
        this.callManagerListeners.add(callListener);
        return () -> this.callManagerListeners.remove(callListener);
    }

    public void removeListener(@NonNull CallListener callListener) {
        if (callListener == null) {
            throw new NullPointerException("callListener is marked non-null but is null");
        }
        this.callManagerListeners.remove(callListener);
    }

    private class EventForwarder
    implements CallListener {
        private final CallListener baseListener;

        public EventForwarder() {
            this.baseListener = new CallListener(){};
        }

        @Override
        public void onStart(CallStarted callInProgress) {
            ServerCallManager.this.callManagerListeners.forEach(l -> l.onStart(callInProgress));
            this.baseListener.onStart(callInProgress);
        }

        @Override
        public void onComplete(CallCompleted callCompleted) {
            ServerCallManager.this.callManagerListeners.forEach(l -> l.onComplete(callCompleted));
            this.baseListener.onComplete(callCompleted);
        }

        @Override
        public void onError(CallErrored callErrored) {
            ServerCallManager.this.callManagerListeners.forEach(l -> l.onError(callErrored));
            this.baseListener.onError(callErrored);
        }

        @Override
        public void onObservablePropertyUpdate(SiLACall baseCall, String value) {
            ServerCallManager.this.callManagerListeners.forEach(l -> l.onObservablePropertyUpdate(baseCall, value));
            this.baseListener.onObservablePropertyUpdate(baseCall, value);
        }

        @Override
        public void onObservableCommandInit(SiLACall baseCall, SiLAFramework.CommandConfirmation command) {
            ServerCallManager.this.callManagerListeners.forEach(l -> l.onObservableCommandInit(baseCall, command));
            this.baseListener.onObservableCommandInit(baseCall, command);
        }

        @Override
        public void onObservableCommandExecutionInfo(SiLACall baseCall, SiLAFramework.ExecutionInfo executionInfo) {
            ServerCallManager.this.callManagerListeners.forEach(l -> l.onObservableCommandExecutionInfo(baseCall, executionInfo));
            this.baseListener.onObservableCommandExecutionInfo(baseCall, executionInfo);
        }

        @Override
        public void onObservableIntermediateResponse(SiLACall baseCall, DynamicMessage response) {
            ServerCallManager.this.callManagerListeners.forEach(l -> l.onObservableIntermediateResponse(baseCall, response));
            this.baseListener.onObservableIntermediateResponse(baseCall, response);
        }

        public EventForwarder(CallListener baseListener) {
            this.baseListener = baseListener;
        }
    }

    public static class RunningServerCall {
        private final ExecutableServerCall executableServerCall;
        private final Future<String> future;

        public RunningServerCall(ExecutableServerCall executableServerCall, Future<String> future) {
            this.executableServerCall = executableServerCall;
            this.future = future;
        }

        public ExecutableServerCall getExecutableServerCall() {
            return this.executableServerCall;
        }

        public Future<String> getFuture() {
            return this.future;
        }
    }
}

