/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import sila2.org.silastandard.SiLABinaryTransfer;

public class BinaryDownloader {
    static final int MAX_CHUNK_SIZE = 0x200000;
    private final OutputStream outputStream;
    private final UUID binaryTransferUUID;
    private int chunkIndex = 0;

    public BinaryDownloader(@NonNull OutputStream outputStream, @NonNull UUID binaryTransferUUID) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (binaryTransferUUID == null) {
            throw new NullPointerException("binaryTransferUUID is marked non-null but is null");
        }
        this.outputStream = outputStream;
        this.binaryTransferUUID = binaryTransferUUID;
    }

    public synchronized SiLABinaryTransfer.GetChunkRequest getNextChunkDownloadRequest(@NonNull SiLABinaryTransfer.GetBinaryInfoResponse binaryInfo) {
        if (binaryInfo == null) {
            throw new NullPointerException("binaryInfo is marked non-null but is null");
        }
        int chunkSizeModulo = BinaryDownloader.getChunkSizeModulo(binaryInfo.getBinarySize());
        int chunkCount = BinaryDownloader.getChunkCount(binaryInfo.getBinarySize());
        if (chunkCount == this.chunkIndex) {
            throw new RuntimeException("No more binary chunk to download");
        }
        int lengthToRead = this.chunkIndex == chunkCount - 1 ? chunkSizeModulo : 0x200000;
        SiLABinaryTransfer.GetChunkRequest getChunkRequest = SiLABinaryTransfer.GetChunkRequest.newBuilder().setLength(lengthToRead).setOffset((long)this.chunkIndex * 0x200000L).setBinaryTransferUUID(this.binaryTransferUUID.toString()).build();
        ++this.chunkIndex;
        return getChunkRequest;
    }

    public static int getChunkSizeModulo(long binarySize) {
        return (int)(binarySize % 0x200000L);
    }

    public static int getChunkCount(long binarySize) {
        int chunkSizeModulo = BinaryDownloader.getChunkSizeModulo(binarySize);
        return (int)(binarySize / 0x200000L) + (chunkSizeModulo > 0 ? 1 : 0);
    }

    public synchronized int writeChunk(SiLABinaryTransfer.GetChunkResponse chunkResponse) throws IOException {
        int receivedChunkIndex = (int)(chunkResponse.getOffset() / 0x200000L);
        if (this.chunkIndex - 1 != receivedChunkIndex) {
            throw new RuntimeException("Binary chunks must be written in sequential order");
        }
        try (InputStream inputStream = chunkResponse.getPayload().newInput();){
            int n = IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
            return n;
        }
    }

    public SiLABinaryTransfer.GetBinaryInfoRequest getBinaryInfoRequest() {
        return SiLABinaryTransfer.GetBinaryInfoRequest.newBuilder().setBinaryTransferUUID(this.binaryTransferUUID.toString()).build();
    }

    public UUID getBinaryTransferUUID() {
        return this.binaryTransferUUID;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }
}

