/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila_java.library.manager.executor.BinaryDownloader;

public class BinaryDownloaderStream
implements StreamObserver<SiLABinaryTransfer.GetChunkResponse> {
    private final CompletableFuture<Void> voidCompletableFuture = new CompletableFuture();
    private final BinaryDownloader binaryDownloader;
    private final AtomicInteger nbReceived = new AtomicInteger(0);
    private final SiLABinaryTransfer.GetBinaryInfoResponse binaryInfo;
    private final int chunkCount;
    private StreamObserver<SiLABinaryTransfer.GetChunkRequest> responseObserver;

    public BinaryDownloaderStream(@NonNull BinaryDownloader binaryDownloader, @NonNull SiLABinaryTransfer.GetBinaryInfoResponse binaryInfo) {
        if (binaryDownloader == null) {
            throw new NullPointerException("binaryDownloader is marked non-null but is null");
        }
        if (binaryInfo == null) {
            throw new NullPointerException("binaryInfo is marked non-null but is null");
        }
        this.binaryDownloader = binaryDownloader;
        this.binaryInfo = binaryInfo;
        int chunkSizeModulo = (int)(binaryInfo.getBinarySize() % 0x200000L);
        this.chunkCount = (int)(binaryInfo.getBinarySize() / 0x200000L) + (chunkSizeModulo > 0 ? 1 : 0);
    }

    public void startDownload(StreamObserver<SiLABinaryTransfer.GetChunkRequest> responseObserver) {
        this.responseObserver = responseObserver;
        this.responseObserver.onNext((Object)this.binaryDownloader.getNextChunkDownloadRequest(this.binaryInfo));
    }

    public void onNext(SiLABinaryTransfer.GetChunkResponse getChunkResponse) {
        if (this.nbReceived.get() == this.chunkCount) {
            this.responseObserver.onCompleted();
            this.voidCompletableFuture.complete(null);
        } else {
            this.nbReceived.getAndIncrement();
            try {
                this.binaryDownloader.writeChunk(getChunkResponse);
            }
            catch (IOException e) {
                this.onError(e);
            }
            this.responseObserver.onNext((Object)this.binaryDownloader.getNextChunkDownloadRequest(this.binaryInfo));
        }
    }

    public void onError(Throwable throwable) {
        this.voidCompletableFuture.obtrudeException(throwable);
    }

    public void onCompleted() {
        if (this.voidCompletableFuture.isDone()) {
            return;
        }
        if (this.nbReceived.get() != this.chunkCount) {
            this.voidCompletableFuture.obtrudeException(new RuntimeException("Stream completed before downloading all binary chunks"));
        } else {
            this.voidCompletableFuture.complete(null);
        }
    }

    public CompletableFuture<Void> getVoidCompletableFuture() {
        return this.voidCompletableFuture;
    }
}

