/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.executor;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila_java.library.manager.executor.BinaryUploader;

public class BinaryUploaderStream
implements StreamObserver<SiLABinaryTransfer.UploadChunkResponse> {
    private final CompletableFuture<Void> voidCompletableFuture = new CompletableFuture();
    private final String binaryTransferUUID;
    private final BinaryUploader binaryUploader;
    private final AtomicInteger nbReceived = new AtomicInteger(0);
    private StreamObserver<SiLABinaryTransfer.UploadChunkRequest> responseObserver;

    public BinaryUploaderStream(@NonNull BinaryUploader binaryUploader, @NonNull String binaryTransferUUID) {
        if (binaryUploader == null) {
            throw new NullPointerException("binaryUploader is marked non-null but is null");
        }
        if (binaryTransferUUID == null) {
            throw new NullPointerException("binaryTransferUUID is marked non-null but is null");
        }
        this.binaryUploader = binaryUploader;
        this.binaryTransferUUID = binaryTransferUUID;
    }

    public void startUpload(StreamObserver<SiLABinaryTransfer.UploadChunkRequest> responseObserver) {
        this.responseObserver = responseObserver;
        try {
            this.responseObserver.onNext((Object)this.binaryUploader.getNextChunkUploadRequest(this.binaryTransferUUID));
        }
        catch (IOException e) {
            this.onError(e);
        }
    }

    public void onNext(SiLABinaryTransfer.UploadChunkResponse uploadChunkResponse) {
        if (this.nbReceived.get() == this.binaryUploader.getChunkCount()) {
            this.responseObserver.onCompleted();
            this.voidCompletableFuture.complete(null);
        } else {
            this.nbReceived.getAndIncrement();
            try {
                this.responseObserver.onNext((Object)this.binaryUploader.getNextChunkUploadRequest(this.binaryTransferUUID));
            }
            catch (IOException e) {
                this.onError(e);
            }
        }
    }

    public void onError(Throwable throwable) {
        this.voidCompletableFuture.obtrudeException(throwable);
    }

    public void onCompleted() {
        if (this.voidCompletableFuture.isDone()) {
            return;
        }
        if (this.nbReceived.get() != this.binaryUploader.getChunkCount()) {
            this.voidCompletableFuture.obtrudeException(new RuntimeException("Stream completed before uploading all binary chunks"));
        } else {
            this.voidCompletableFuture.complete(null);
        }
    }

    public CompletableFuture<Void> getVoidCompletableFuture() {
        return this.voidCompletableFuture;
    }
}

