/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager.server_management;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.net.ConnectException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.core.models.Feature;
import sila_java.library.core.sila.mapping.feature.FeatureGenerator;
import sila_java.library.core.utils.Utils;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.executor.ServerCallManager;
import sila_java.library.manager.models.Server;
import sila_java.library.manager.server_management.ServerConnectionException;
import sila_java.library.server_base.config.ServerConfiguration;
import sila_java.library.server_base.identification.ServerInformation;

public abstract class ServerLoading {
    private static final Logger log = LoggerFactory.getLogger(ServerLoading.class);
    private static final long MAX_SERVICE_TIMEOUT = 5L;

    public static void loadServer(@NonNull Server server, @NonNull ManagedChannel managedChannel) throws ServerLoadingException {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (managedChannel == null) {
            throw new NullPointerException("managedChannel is marked non-null but is null");
        }
        SiLAServiceGrpc.SiLAServiceBlockingStub siLAService = SiLAServiceGrpc.newBlockingStub((Channel)managedChannel);
        try {
            UUID serverUUID = ServerLoading.getServerId(siLAService);
            log.info("Got serverUUID: {}", (Object)serverUUID);
            String serverName = ServerLoading.getServerName(siLAService);
            String serverType = ServerLoading.getServerType(siLAService);
            String serverDescription = ServerLoading.getServerDescription(siLAService, serverName);
            String serverVendorURL = ServerLoading.getServerVendor(siLAService);
            String serverVersion = ServerLoading.getServerVersion(siLAService);
            server.setConfiguration(new ServerConfiguration(serverName, serverUUID));
            server.setInformation(new ServerInformation(serverType, serverDescription, serverVendorURL, serverVersion));
            log.info("{} Saved Server Information", (Object)serverName);
            SiLAServiceOuterClass.Get_ImplementedFeatures_Responses featureList = ServerLoading.getFeatureList(siLAService, serverName);
            ServerLoading.loadFeatures(siLAService, server, featureList);
        }
        catch (StatusRuntimeException e) {
            String errorMessage = String.format("SiLA Service doesn't return because %s. Timeout was set to %d s", e.getMessage(), 5L);
            throw new ServerLoadingException(errorMessage);
        }
        catch (IOException e) {
            throw new ServerLoadingException(e.getMessage());
        }
    }

    public static ManagedChannel attemptConnectionWithServer(@NonNull Server server, @NonNull Optional<ClientInterceptor> clientInterceptor, boolean allowUnsecure, @Nullable X509Certificate certificate) throws ServerConnectionException {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (clientInterceptor == null) {
            throw new NullPointerException("clientInterceptor is marked non-null but is null");
        }
        if (!allowUnsecure && certificate == null) {
            log.warn("A valid certificate must be provided to establish a secure connection!");
            throw new ServerConnectionException(server);
        }
        ServerCallManager serverCallManager = ServerManager.getInstance().getServerCallManager();
        ManagedChannelBuilder<?> builder = serverCallManager.newChannelBuilderWithEncryption(server.getHost(), server.getPort(), certificate);
        clientInterceptor.ifPresent(xva$0 -> builder.intercept(new ClientInterceptor[]{xva$0}));
        ManagedChannel encryptedChannel = builder.build();
        try {
            UUID serverId = ServerLoading.getServerId(SiLAServiceGrpc.newBlockingStub((Channel)encryptedChannel));
            server.setNegotiationType(Server.NegotiationType.TLS);
            log.info("Connection to remote server {} using TLS successful", (Object)serverId);
            return encryptedChannel;
        }
        catch (StatusRuntimeException e) {
            try {
                encryptedChannel.shutdown();
            }
            catch (StatusRuntimeException e1) {
                log.warn("Unable to shutdown managed channel!", (Throwable)e1);
            }
            if (e.getCause() instanceof ConnectException) {
                log.warn("Unable to connect to server");
                throw new ServerConnectionException(server);
            }
            log.warn("Unable to load server through TLS!");
            if (!allowUnsecure) {
                throw new ServerConnectionException(server);
            }
            builder = serverCallManager.newChannelBuilderWithoutEncryption(server.getHost(), server.getPort());
            clientInterceptor.ifPresent(xva$0 -> builder.intercept(new ClientInterceptor[]{xva$0}));
            ManagedChannel plainTextChannel = builder.build();
            try {
                log.warn("Deprecated usage of unsecure connection with remote server!");
                UUID serverId = ServerLoading.getServerId(SiLAServiceGrpc.newBlockingStub((Channel)plainTextChannel));
                server.setNegotiationType(Server.NegotiationType.PLAIN_TEXT);
                log.info("Connection to remote server {} using plain-text successful", (Object)serverId);
                return plainTextChannel;
            }
            catch (StatusRuntimeException e2) {
                try {
                    plainTextChannel.shutdown();
                }
                catch (StatusRuntimeException e1) {
                    log.warn("Unable to shutdown managed channel!", (Throwable)e2);
                }
                log.warn("Unable to load server through plain-text!");
                throw new ServerConnectionException(server);
            }
        }
    }

    public static UUID getServerId(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        String serverUUIDStr = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getServerUUID(SiLAServiceOuterClass.Get_ServerUUID_Parameters.newBuilder().build()).getServerUUID().getValue();
        return UUID.fromString(serverUUIDStr);
    }

    public static String getServerName(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        String serverName = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getServerName(SiLAServiceOuterClass.Get_ServerName_Parameters.newBuilder().build()).getServerName().getValue();
        log.debug("Got serverName: {}", (Object)serverName);
        return serverName;
    }

    private static SiLAServiceOuterClass.Get_ImplementedFeatures_Responses getFeatureList(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService, @NonNull String serverName) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        long start = System.currentTimeMillis();
        SiLAServiceOuterClass.Get_ImplementedFeatures_Responses featureList = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getImplementedFeatures(SiLAServiceOuterClass.Get_ImplementedFeatures_Parameters.newBuilder().build());
        log.debug("{} Got List of Features in {} ms", (Object)serverName, (Object)(System.currentTimeMillis() - start));
        return featureList;
    }

    private static String getServerVersion(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        String serverVersion = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getServerVersion(SiLAServiceOuterClass.Get_ServerVersion_Parameters.newBuilder().build()).getServerVersion().getValue();
        log.debug("Got serverVersion: {}", (Object)serverVersion);
        return serverVersion;
    }

    private static String getServerVendor(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        String serverVendorURL = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getServerVendorURL(SiLAServiceOuterClass.Get_ServerVendorURL_Parameters.newBuilder().build()).getServerVendorURL().getValue();
        log.debug("Got serverVendorURL: {}", (Object)serverVendorURL);
        return serverVendorURL;
    }

    private static String getServerDescription(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService, @NonNull String serverName) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        String serverDescription = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getServerDescription(SiLAServiceOuterClass.Get_ServerDescription_Parameters.newBuilder().build()).getServerDescription().getValue();
        log.debug("{} Got serverDescription: {}", (Object)serverName, (Object)serverDescription);
        return serverDescription;
    }

    private static String getServerType(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService) {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        String serverType = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getServerType(SiLAServiceOuterClass.Get_ServerType_Parameters.newBuilder().build()).getServerType().getValue();
        log.debug("Got serverType: {}", (Object)serverType);
        return serverType;
    }

    private static void loadFeatures(@NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAService, @NonNull Server server, @NonNull SiLAServiceOuterClass.Get_ImplementedFeatures_Responses featureList) throws IOException {
        if (siLAService == null) {
            throw new NullPointerException("siLAService is marked non-null but is null");
        }
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (featureList == null) {
            throw new NullPointerException("featureList is marked non-null but is null");
        }
        for (SiLAFramework.String featureIdentifier : featureList.getImplementedFeaturesList()) {
            Feature featurePojo;
            SiLAServiceOuterClass.GetFeatureDefinition_Parameters par = SiLAServiceOuterClass.GetFeatureDefinition_Parameters.newBuilder().setFeatureIdentifier(featureIdentifier).build();
            SiLAServiceOuterClass.GetFeatureDefinition_Responses featureDefinition = ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAService.withDeadlineAfter(5L, TimeUnit.SECONDS)).getFeatureDefinition(par);
            String rawFeatureDefinition = Utils.cleanupXMLString((String)featureDefinition.getFeatureDefinition().getValue());
            try {
                featurePojo = FeatureGenerator.generateFeature((String)rawFeatureDefinition);
            }
            catch (IOException e) {
                throw new IOException(String.format("Parsing of Feature %s failed. Reason=%s", featureIdentifier, e.getMessage()));
            }
            log.debug("Feature {}=", (Object)featureIdentifier);
            log.debug("{} ", (Object)featurePojo);
            server.getFeatures().add(featurePojo);
        }
    }

    private ServerLoading() {
    }

    public static class ServerLoadingException
    extends Exception {
        ServerLoadingException(String errorMessage) {
            super(errorMessage);
        }
    }
}

